<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_shortlists', function (Blueprint $table) {
            $table->id();
            $table->date('shortlist_date')->nullable();
            $table->bigInteger('product_id')->nullable();
            $table->bigInteger('account_id')->nullable();
            $table->bigInteger('product_price_id')->nullable();
            $table->double('quantity')->nullable();
            $table->integer('company_id')->nullable();
            $table->string('status',100)->nullable();
            $table->integer('created_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_shortlists');
    }
};
