<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('death_registers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('ipd_id');
            $table->date('death_date');
            $table->time('death_time');
            $table->text('death_reason')->nullable();
            $table->string('guardian_name', 200);
            $table->text('death_report')->nullable();
            $table->string('attachment_name', 255)->nullable();
            $table->string('file_url', 255);
            $table->tinyInteger('is_active')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('death_registers');
    }
};
