<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
     public function up()
    {
        Schema::create('logistic_bookings', function (Blueprint $table) {
            // Primary Key
             $table->id();

            // booking Details
            $table->string('main_booking_no', 25)->unique();
            $table->string('manual_lr_no', 25)->unique()->nullable();
            $table->string('branch_booking_no', 25)->nullable();
            $table->string('voucher_type_booking_no', 25)->nullable();
            $table->string('voucher_type_code', 50)->nullable();
            $table->date('booking_date');
            $table->unsignedBigInteger('payment_term_id');
            $table->unsignedBigInteger('last_voucher_count')->nullable();
            $table->unsignedBigInteger('last_voucher_type_count')->nullable();

            // Voucher Details
            $table->unsignedInteger('voucher_type_id');
            $table->unsignedInteger('tax_paid_by_id');

            // Party Information
            $table->unsignedBigInteger('consignor_id');
            $table->unsignedBigInteger('consignee_id');
            $table->unsignedInteger('vendor_id');
            $table->unsignedBigInteger('bill_to_account_id');

            // Location Details
            $table->unsignedInteger('from_location_id');
            $table->unsignedInteger('to_location_id');
            $table->unsignedInteger('destination_branch_id')->nullable();
            $table->unsignedInteger('despatch_from_address_id');
            $table->unsignedInteger('bill_to_address_id')->nullable();
            $table->unsignedInteger('ship_to_address_id');

            // Transport Details
            $table->unsignedInteger('transportation_mode_id');
            $table->tinyInteger('transport_type_id');
            $table->string('shipping_risk');
            $table->unsignedInteger('delivery_type_id');
            $table->enum('insurance', ['YES', 'NO'])->default('NO');
            $table->unsignedInteger('broker_id');
            $table->decimal('broker_commission', 12, 2)->nullable();

            // Booking Status and Tracking
            $table->enum('booking_status', ['PENDING', 'CONFIRMED', 'CANCELLED','DELEIVERED','DELETED']);
            $table->string('tracking_id', 50)->nullable();

            // Additional Information
            $table->string('party_mark', 255);
            $table->text('booking_remarks');
            $table->boolean('hide_booking_amount_for_branch')->default(false);

            // Company Information
            $table->unsignedInteger('company_id');

            // Audit Fields
            $table->unsignedInteger('created_by_user_id');
            $table->unsignedInteger('updated_by_user_id')->nullable();
            $table->unsignedInteger('deleted_by_user_id')->nullable();
            $table->timestamps(); // Includes created_at and updated_at
            $table->softDeletes(); // Includes deleted_at

            
            // Indexes and Foreign Keys
            $table->index('consignor_id');
            $table->index('consignee_id');
            $table->index('from_location_id');
            $table->index('to_location_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */

    public function down()
    {
        Schema::dropIfExists('logistic_bookings');
        }
};
