<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('logistic_booking_details', function (Blueprint $table) {
            // Primary Key
             $table->id();

            // Foreign Keys
            $table->unsignedBigInteger('booking_id');
            $table->unsignedBigInteger('product_id');
            $table->unsignedBigInteger('product_batch_id')->nullable();

            // Item and Material Details
            $table->text('item_details');
            $table->longText('material_details')->nullable()->charset('utf8mb4')->collation('utf8mb4_bin')->check('json_valid(material_details)');

            // Quantitative Attributes
            $table->decimal('quantity', 10, 2);
            $table->decimal('distance', 10, 2);
            $table->decimal('hours', 10, 2);
            $table->decimal('length', 10, 2);
            $table->decimal('breadth', 10, 2);
            $table->decimal('height', 10, 2);
            $table->decimal('divided_by_volume', 10, 2);
            $table->decimal('actual_weight', 10, 2);
            $table->decimal('gross_weight', 10, 2);
            $table->decimal('charge_weight', 10, 2);

            // Weight and Tax Information
            $table->unsignedInteger('weight_type_id')->nullable();
            $table->string('weight_calculation_on', 15);
            $table->unsignedInteger('tax_id');
            $table->string('tax_calculation_type', 20);
            $table->unsignedInteger('rate_calculation_on');
            $table->decimal('rate', 10, 2);

            // Discount and Amount Calculation
            $table->string('discount_type', 20)->nullable();
            $table->decimal('discount_amount', 12, 2)->nullable();
            $table->decimal('discount_percentage', 5, 2)->nullable();
            $table->decimal('total_amount', 13, 4)->nullable();

            // Timestamps
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('logistic_booking_details');
    }
};