<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
            Schema::create('logistic_booking_charges', function (Blueprint $table) {
            // Primary Key
            $table->id();

            // Foreign Keys
            $table->unsignedBigInteger('booking_id');
            $table->unsignedBigInteger('charge_account_id');

            // Charge Details
            $table->date('charge_date')->nullable();
            $table->unsignedInteger('charge_tax_id');
            $table->decimal('charge_quantity', 10, 2)->nullable();
            $table->decimal('charge_rate', 10, 2)->nullable();
            $table->decimal('charge_amount', 10, 2);

            // Remarks and Status
            $table->text('remarks');
            $table->unsignedInteger('created_by_user_id');
            $table->unsignedInteger('updated_by_user_id');
            $table->unsignedInteger('status')->nullable();

            // Timestamps
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('logistic_booking_charges');
    }
};
