<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('logistic_booking_consignor_waybills', function (Blueprint $table) {
             $table->id();
            $table->unsignedBigInteger('booking_id')->nullable();
            $table->date('consignor_invoice_date')->nullable();
            $table->string('consignor_invoice_no', 20)->nullable();
            $table->decimal('consignor_invoice_value', 13, 4)->nullable();
            $table->string('way_bill_no', 20)->nullable();
            $table->date('way_bill_date')->nullable();
            $table->date('way_bill_expiry_date')->nullable();
            $table->string('way_bill_status', 40)->nullable();

            // Indexes
            $table->unique('id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('logistic_booking_consignor_waybills');
    }
};
