<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('letter_heads', function (Blueprint $table) {
            $table->id();
            $table->string('voucher_type_code');  
            $table->boolean('full_image')->default(0);  
            $table->string('image_url', 255);  
            $table->json('image_style');  
            $table->json('title_style');  
            $table->json('sub_title_style');  
            $table->text('content_alignment')->nullable();  
            $table->text('logo_position')->nullable();  
            $table->unsignedBigInteger('company_id'); 
            $table->boolean('status')->default(1);  
            $table->boolean('is_default')->default(0);  
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('letter_heads');
    }
};