<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('districts')) {
        Schema::create('districts', function (Blueprint $table) {
            $table->id(); 
            $table->string('district_name')->nullable(); 
            $table->string('district_short_name', 50)->nullable(); 
            $table->integer('district_numeric_code')->nullable(); 
            $table->unsignedBigInteger('state_id')->nullable(); 
            $table->boolean('status'); 
            $table->timestamps();
        });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('districts');
    }
};
