<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('logistic_booking_insurances', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('booking_id')->nullable()->onDelete('set null');
            $table->string('insurance_provider', 255)->nullable();
            $table->date('policy_date')->nullable();
            $table->string('policy_no', 100)->nullable();
            $table->decimal('policy_percentage', 10, 2)->nullable();
            $table->decimal('policy_amount', 10, 2)->nullable();
            $table->decimal('claim_amount', 10, 2)->nullable();
            $table->timestamps();

            $table->index('booking_id'); // Adding an index to improve performance on booking_id column.

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('logistic_booking_insurances');
    }
};
