<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('logistic_booking_container_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('booking_id')->nullable();
            $table->string('container_no', 50)->nullable();
            $table->unsignedBigInteger('container_size_id')->nullable();
            $table->unsignedBigInteger('container_type_id')->nullable();
            $table->integer('lc_authority_id')->nullable();
            $table->string('lc_no', 50)->nullable();
            $table->date('lc_date')->nullable();
            $table->unsignedBigInteger('cargo_type_id')->nullable();
            $table->decimal('cargo_weight', 10, 2)->nullable();
            $table->decimal('cargo_volume', 10, 2)->nullable();
            $table->string('delivery_order_no', 50)->nullable();
            $table->date('delivery_order_validity_date')->nullable();
            $table->integer('cfs_agent_id')->nullable();
            $table->unsignedBigInteger('cargo_shipping_line_id')->nullable();
            $table->unsignedBigInteger('vehicle_type_id')->nullable();
            $table->string('seal_no', 50)->nullable();
            $table->string('tracking_number', 50)->nullable();
            $table->boolean('temperature_control')->default(0);
            $table->string('temperature_range', 20)->nullable();
            $table->unsignedBigInteger('loading_port_id')->nullable();
            $table->unsignedBigInteger('destination_port_id')->nullable();
            $table->date('estimated_arrival_date')->nullable();
            $table->date('offload_destination_date')->nullable();
            $table->date('container_return_expiry_date')->nullable();
            $table->date('container_return_date')->nullable();
            $table->unsignedBigInteger('container_return_status_id')->nullable();
            $table->decimal('insurance_value', 15, 2)->nullable();
            $table->unsignedBigInteger('customs_clearance_status_id')->nullable();
            $table->boolean('security_compliance')->default(1);
            $table->string('bill_of_landing_no', 255)->nullable();
            $table->string('unique_vessel_no', 255)->nullable();
            $table->string('vessel_name', 255)->nullable();
            $table->string('voyage_no', 255)->nullable();
            $table->text('remarks')->nullable();
            $table->timestamps(0);
            $table->softDeletes();

            // Indexes
            $table->index('booking_id');
            $table->index('lc_authority_id');
            $table->index('cfs_agent_id');
            $table->index('loading_port_id');
            $table->index('destination_port_id');
            $table->index('container_size_id');
            $table->index('container_type_id');
            $table->index('cargo_type_id');
            $table->index('vehicle_type_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('logistic_booking_container_details');
    }
};
                                          