<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('letter_heads', function (Blueprint $table) {
            $table->string('custom_logo_url', 255)->after('image_url'); 
            $table->boolean('custom_logo_status')->default("0")->after('is_default');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('letter_heads', function (Blueprint $table) {
            $table->dropColumn('custom_logo_url'); 
            $table->boolean('custom_logo_status');
        });
    }
};
