<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('responsible_teams', function (Blueprint $table) {
            $table->text('responsibility')->nullable()->after('status'); 
            $table->boolean('task_accepted_status')->default(0)->after('status');
            $table->text('reject_reason')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('responsible_teams', function (Blueprint $table) {
            $table->dropColumn(['responsibility','task_accepted_status','reject_reason']);
        });
    }
};
