<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('product_groups', function (Blueprint $table) {
            $table->string('thumbnail_image', 255)->nullable()->after('description');
            $table->string('banner_image', 255)->nullable()->after('thumbnail_image');
        });


        Schema::table('product_categories', function (Blueprint $table) {
            $table->string('thumbnail_image', 255)->nullable()->after('description');
            $table->string('banner_image', 255)->nullable()->after('thumbnail_image');
        });


        Schema::table('product_brands', function (Blueprint $table) {
            $table->string('thumbnail_image', 255)->nullable()->after('description');
            $table->string('banner_image', 255)->nullable()->after('thumbnail_image');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('product_groups', function (Blueprint $table) {
            $table->dropColumn('thumbnail_image');
            $table->dropColumn('banner_image');
        });

        Schema::table('product_categories', function (Blueprint $table) {
            $table->dropColumn('thumbnail_image');
            $table->dropColumn('banner_image');
        });

        Schema::table('product_brands', function (Blueprint $table) {
            $table->dropColumn('thumbnail_image');
            $table->dropColumn('banner_image');
        });
    }
};
