<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('career_vacancies')) {
        Schema::create('career_vacancies', function (Blueprint $table) {
            $table->id();  
            $table->string('position');  
            $table->string('qualification');
            $table->string('specialty');  
            $table->string('experience', 50);
            $table->string('location');  
            $table->enum('work_type', ['Full-time', 'Part-time', 'Remote', 'Contract']);  
            $table->integer('no_of_vacancies');
            $table->string('job_apply_link');  
            $table->date('start_date');  
            $table->date('end_date'); 
            $table->tinyInteger('priority');  
            $table->boolean('status')->default(1);  
            $table->unsignedBigInteger('created_by');  
            $table->timestamps(); 
            $table->softDeletes();  

        });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('career_vacancies');
    }
};
