<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('job_applications', function (Blueprint $table) {
            $table->id();
            $table->string('application_no')->nullable(); 
            $table->unsignedInteger('vacancy_id')->nullable(); 
            $table->string('candidate_name', 255)->nullable(); 
            $table->string('candidate_email', 255)->nullable();
            $table->string('candidate_phone', 20)->nullable(); 
            $table->text('cover_letter')->nullable(); 
            $table->string('cv_attachment', 255)->nullable();
            $table->string('city')->nullable();
            $table->string('position')->nullable();
            $table->timestamp('applied_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->string('linkedin_profile_link', 255)->nullable(); 
            $table->enum('status', ['Pending', 'Reviewed', 'Shortlisted', 'Rejected', 'Accepted'])->default('Pending'); 
            $table->text('review_remarks')->nullable(); 
            $table->unsignedInteger('reviewed_by')->nullable(); 
            $table->timestamp('reviewed_at')->nullable(); 
            $table->timestamps();  
            $table->softDeletes(); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('job_applications');
    }
};
