<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('page_contents', function (Blueprint $table) {
            $table->id();
            $table->integer('page_id')->nullable(); // Integer for page_id (no foreign key)
            $table->string('content_type', 255)->nullable(); // VARCHAR(255)
            $table->text('content_title')->nullable(); // TEXT for content title
            $table->text('content_details')->nullable(); // TEXT for content details, nullable if needed
            $table->text('content_data')->nullable(); // TEXT for content data, nullable if needed
            $table->integer('content_id')->nullable(); // INT for content_id
            $table->integer('priority')->default(0); // Default priority is 0
            $table->boolean('status')->default(true); // TINYINT(1) for status, default is 1 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('page_contents');
    }
};
