<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('pipeline_stages', function (Blueprint $table) {
            $table->boolean('status')->after('task_group_id')->default(1);
            $table->decimal('priority')->after('status')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('pipeline_stages', function (Blueprint $table) {
            $table->dropColumn('status');
            $table->dropColumn('priority');
        });
    }
};
