<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use App\Models\MasterCategory;
use Illuminate\Database\Seeder;

class AccountCategoriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $settlement_types = array(
            [
                'id'            => '1',
                'category_name' => 'General',
                'category_code' => 'GENERAL',
                'prefix'        => 'GN',
                'status'        => '1',
                'is_default'    => '1',
                'created_at'    => now(),
                'updated_at'    => now(),
            ]
        );

        foreach ($settlement_types as $category) {
            MasterCategory::firstOrCreate(
                ['category_code' => $category['category_code']],
                $category
            );
        }
    }
}
