<?php

namespace Database\Seeders;

use App\Models\AccountSettlementType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AccountSettlementTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $settlement_types = array(
            array(
                'id'          => '1',
                'name'        => 'BILL TO BILL',
                'code'        => 'BILL_TO_BILL',
                'priority'    => '1',
                'status'      => '1',
                'is_default'  => '1',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ),
            array(
                'id'          => '2',
                'name'        => 'LEDGER',
                'code'        => 'LEDGER',
                'priority'    => '2',
                'status'      => '1',
                'is_default'  => '0',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            )
        );
        // DB::table('account_settlement_types')->insert($settlement_types);
        foreach ($settlement_types as $category) {
            AccountSettlementType::firstOrCreate(
                ['code' => $category['code']],
                $category
            );
        }
    }
}
