<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\MasterType;

class AccountTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the MasterType table
         */
        // if (\App::environment('local')) {
        //     MasterType::truncate();
        // }

        $types = [
            [
                'type_name'           => 'General',
                'accounting_group_id' => NULL,
                'account_category_id' => NULL,
                'type_code'           => 'GENERAL',
                'prefix'              => NULL,
                'count'               => '1',
                'is_default'          => 1,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'TPA/Corporates',
                'accounting_group_id' => 11,
                'account_category_id' => 1,
                'type_code'           => 'TPA',
                'prefix'              => 'TPA',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Student',
                'accounting_group_id' => 11,
                'account_category_id' => 1,
                'type_code'           => 'STUDENT',
                'prefix'              => 'STD',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Patient',
                'accounting_group_id' => 11,
                'account_category_id' => 1,
                'type_code'           => 'PATIENT',
                'prefix'              => 'PAT',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Doctor',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'DOCTOR',
                'prefix'              => 'DRS',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Referral Partner',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'REFERRAL_PARTNER',
                'prefix'              => 'REF',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Collection Agent',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'COLLECTION_AGENT',
                'prefix'              => 'CLA',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Delivery Partner',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'DELIVERY_PARTNER',
                'prefix'              => 'DLP',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Faculty',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'FACULTY',
                'prefix'              => 'FLT',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Customer',
                'accounting_group_id' => 11,
                'account_category_id' => 1,
                'type_code'           => 'CUSTOMER',
                'prefix'              => 'CUS',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Payment Mode',
                'accounting_group_id' => 7,
                'account_category_id' => 1,
                'type_code'           => 'PAYMENT_MODE',
                'prefix'              => 'PMT',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 0,

            ],
            [
                'type_name'           => 'Driver',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'DRIVER',
                'prefix'              => 'DRV',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Vehicle Vendor',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'VEHICLE_VENDOR',
                'prefix'              => 'VVN',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 0,

            ],
            [
                'type_name'           => 'Vendor',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'VENDOR',
                'prefix'              => 'VEN',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 0,

            ],
            [
                'type_name'           => 'Sales Agent',
                'accounting_group_id' => 11,
                'account_category_id' => 1,
                'type_code'           => 'SALES_AGENT',
                'prefix'              => 'SLA',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Fuel Station',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'FUEL_STATION',
                'prefix'              => 'FUL',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 0,

            ],
            [
                'type_name'           => 'Vehicle',
                'accounting_group_id' => 2,
                'account_category_id' => 1,
                'type_code'           => 'VEHICLE',
                'prefix'              => 'VHL',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 0,

            ],
            [
                'type_name'           => 'Transporter',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'TRANSPORTER',
                'prefix'              => 'TRN',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Technician',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'TECHNICIAN',
                'prefix'              => 'TEC',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
            [
                'type_name'           => 'Container Freight Station(CFS)',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'CONTAINER_FREIGHT_STATION',
                'prefix'              => 'CFS',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 0,

            ],
            [
                'type_name'           => 'Cargo Shipping Line',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'CARGO_SHIPPING_LINE',
                'prefix'              => 'SHP',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 0,

            ],
            [
                'type_name'           => 'Broker',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'BROKER',
                'prefix'              => 'BRK',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,
            ],
            [
                'type_name'           => 'Employee',
                'accounting_group_id' => 17,
                'account_category_id' => 1,
                'type_code'           => 'EMPLOYEE',
                'prefix'              => 'EMP',
                'count'               => NULL,
                'is_default'          => 0,
                'is_person'           => 1,

            ],
        ];

        foreach ($types as $data) {
            MasterType::firstOrCreate(
                ['type_code' => $data['type_code']],
                $data
            );
        }
    }
}
