<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\AccountingGroup;

class AccountingGroupsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the countries table
         */
        // if (\App::environment('local')) {
        //     AccountingGroup::truncate();
        // }

        $groups = [
            [
                'name'               => 'Current Asset',
                'code'               => 'CURRENT_ASSET',
                'accounting_type_id' => '1',
                'prefix'             => 'CA',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '1',
                'created_at'         => date('Y-m-d H:i:s'),
                'updated_at'         => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Fixed Asset',
                'code'               => 'FIXED_ASSET',
                'accounting_type_id' => '1',
                'prefix'             => 'FA',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '2',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Inventory',
                'code'               => 'INVENTORY',
                'accounting_type_id' => '1',
                'prefix'             => 'INV',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '3',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Non-current Asset',
                'code'               => 'NON-CURRENT_ASSET',
                'accounting_type_id' => '1',
                'prefix'             => 'NCA',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '4',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Prepayment',
                'code'               => 'PREPAYMENT',
                'accounting_type_id' => '1',
                'prefix'             => 'PAY',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '5',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Depreciation',
                'code'               => 'DEPRECIATION',
                'accounting_type_id' => '1',
                'prefix'             => 'DEP',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '6',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Cash in Hand',
                'code'               => 'CASH_IN_HAND',
                'accounting_type_id' => '1',
                'prefix'             => 'CIH',
                'count'              => '0',
                'is_payment_mode'    => '1',
                'priority'           => '7',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Bank Account',
                'code'               => 'BANK_ACCOUNT',
                'accounting_type_id' => '1',
                'prefix'             => 'BA',
                'count'              => '0',
                'is_payment_mode'    => '1',
                'priority'           => '8',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Investments',
                'code'               => 'INVESTMENTS',
                'accounting_type_id' => '1',
                'prefix'             => 'INV',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '9',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Stock in Hand',
                'code'               => 'STOCK_IN_HAND',
                'accounting_type_id' => '1',
                'prefix'             => 'SIH',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '10',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Sundry Debtors',
                'code'               => 'SUNDRY_DEBTORS',
                'accounting_type_id' => '1',
                'prefix'             => 'SD',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '11',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Current Liability',
                'code'               => 'CURRENT_LIABILITY',
                'accounting_type_id' => '2',
                'prefix'             => 'CL',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '12',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Non-current Liability',
                'code'               => 'NON-CURRENT_LIABILITY',
                'accounting_type_id' => '2',
                'prefix'             => 'NCL',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '13',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Bank OD',
                'code'               => 'BANK_OD',
                'accounting_type_id' => '2',
                'prefix'             => 'BOD',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '14',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Loans & Liabilities',
                'code'               => 'LOANS_AND_LIABILITIES',
                'accounting_type_id' => '2',
                'prefix'             => 'LAL',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '15',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Duties & Taxes',
                'code'               => 'DUTIES_AND_TAXES',
                'accounting_type_id' => '2',
                'prefix'             => 'TAX',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '16',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Sundry Creditors',
                'code'               => 'SUNDRY_CREDITORS',
                'accounting_type_id' => '2',
                'prefix'             => 'SC',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '17',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],

            [
                'name'               => 'Direct Costs',
                'code'               => 'DIRECT_COSTS',
                'accounting_type_id' => '3',
                'prefix'             => 'DC',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '18',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Direct Expenses',
                'code'               => 'DIRECT_EXPENSES',
                'accounting_type_id' => '3',
                'prefix'             => 'DE',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '19',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Indirect Expenses',
                'code'               => 'INDIRECT_EXPENSES',
                'accounting_type_id' => '3',
                'prefix'             => 'IE',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '20',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Purchase Account',
                'code'               => 'PURCHASE_ACCOUNT',
                'accounting_type_id' => '3',
                'prefix'             => 'PA',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '21',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Sales Account',
                'code'               => 'SALES_ACCOUNT',
                'accounting_type_id' => '4',
                'prefix'             => 'SA',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '22',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Revenue',
                'code'               => 'REVENUE',
                'accounting_type_id' => '4',
                'prefix'             => 'REV',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '23',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Other Income',
                'code'               => 'OTHER_INCOME',
                'accounting_type_id' => '4',
                'prefix'             => 'OI',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '24',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Direct Incomes',
                'code'               => 'DIRECT_INCOMES',
                'accounting_type_id' => '4',
                'prefix'             => 'DI',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '25',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Indirect Income',
                'code'               => 'INDIRECT_INCOME',
                'accounting_type_id' => '4',
                'prefix'             => 'II',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '26',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Equity',
                'code'               => 'EQUITY',
                'accounting_type_id' => '5',
                'prefix'             => 'EQU',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '27',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Branch & Division',
                'code'               => 'BRANCH_AND_DIVISION',
                'accounting_type_id' => '5',
                'prefix'             => 'BAD',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '28',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Capital Account',
                'code'               => 'CAPITAL_ACCOUNT',
                'accounting_type_id' => '5',
                'prefix'             => 'CA',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '29',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'               => 'Suspense Account',
                'code'               => 'SUSPENSE_ACCOUNT',
                'accounting_type_id' => '5',
                'prefix'             => 'SA',
                'count'              => '0',
                'is_payment_mode'    => '0',
                'priority'           => '30',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ]
        ];

        // AccountingGroup::insert($groups);
        foreach ($groups as $category) {
            AccountingGroup::firstOrCreate(
                ['code' => $category['code']],
                $category
            );
        }
    }
}
