<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\AccountingType;
use Illuminate\Support\Facades\DB;

class AccountingTypesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $accounting_types = [
            [
                'name'        => 'Assets',
                'code'        => 'ASSETS',
                'if_increase' => 'DEBIT',
                'if_decrease' => 'CREDIT',
                'priority'    => '1',
                'status'      => '1',
                'is_default'  => '1',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'        => 'Liabilities',
                'code'        => 'LIABILITIES',
                'if_increase' => 'CREDIT',
                'if_decrease' => 'DEBIT',
                'priority'    => '2',
                'status'      => '1',
                'is_default'  => '0',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'        => 'Expenses',
                'code'        => 'EXPENSES',
                'if_increase' => 'DEBIT',
                'if_decrease' => 'CREDIT',
                'priority'    => '3',
                'status'      => '1',
                'is_default'  => '0',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'        => 'Income',
                'code'        => 'INCOME',
                'if_increase' => 'CREDIT',
                'if_decrease' => 'DEBIT',
                'priority'    => '4',
                'status'      => '1',
                'is_default'  => '0',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'        => 'Equity',
                'code'        => 'EQUITY',
                'if_increase' => 'DEBIT',
                'if_decrease' => 'CREDIT',
                'priority'    => '5',
                'status'      => '1',
                'is_default'  => '0',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
            [
                'name'        => 'Capital',
                'code'        => 'CAPITAL',
                'if_increase' => 'DEBIT',
                'if_decrease' => 'CREDIT',
                'priority'    => '6',
                'status'      => '1',
                'is_default'  => '0',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s')
            ],
        ];

        // AccountingType::insert($accounting_types);
        foreach ($accounting_types as $category) {
            AccountingType::firstOrCreate(
                ['code' => $category['code']],
                $category
            );
        }
    }
}
