<?php

namespace Database\Seeders;

use App\Models\MasterType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Account;
use App\Models\AccountingGroup;
use App\Models\AccountingType;

class AccountsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Duties & Taxes')->first();
        $accounting_type = AccountingType::where('name', 'Liabilities')->first();
        Account::firstOrCreate([
            'code'                     => 'Tax_Free',
        ],[
            'account_type_id'          => $account_type->id,
            'account_category_id'      => $accounting_type->id,
            'accounting_group_id'      => $account_group->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'Tax Free',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'Tax Free',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => '3%_GST',
        ],[
            'account_type_id'          => $account_type->id,
            'account_category_id'      => $accounting_type->id,
            'accounting_group_id'      => $account_group->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => '3% GST',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => '3% GST',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => '5%_GST',
        ],[
            'account_type_id'          => $account_type->id,
            'account_category_id'      => $accounting_type->id,
            'accounting_group_id'      => $account_group->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => '5% GST',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => '5% GST',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => '12%_GST',
        ],[
            'account_type_id'          => $account_type->id,
            'account_category_id'      => $accounting_type->id,
            'accounting_group_id'      => $account_group->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => '12% GST',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => '12% GST',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => '18%_GST',
        ],[
            'account_type_id'          => $account_type->id,
            'account_category_id'      => $accounting_type->id,
            'accounting_group_id'      => $account_group->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => '18% GST',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => '18% GST',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => '28%_GST',
        ],[
            'account_type_id'          => $account_type->id,
            'account_category_id'      => $accounting_type->id,
            'accounting_group_id'      => $account_group->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => '28% GST',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => '28% GST',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => '28% + Cess_GST',
        ],[
            'account_type_id'          => $account_type->id,
            'account_category_id'      => $accounting_type->id,
            'accounting_group_id'      => $account_group->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => '28% + Cess GST',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => '28% + Cess GST',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);

        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Bank Account')->first();
        $accounting_type = AccountingType::where('name', 'Assets')->first();
        Account::firstOrCreate([
            'code'                     => 'BANK',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'BANK',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'BANK',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Bank OD')->first();
        $category        = AccountingType::where('name', 'Assets')->first();
        Account::firstOrCreate([
            'code'                     => 'BANK_OVERDRAFT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'BANK OVERDRAFT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'BANK OVERDRAFT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Capital Account')->first();
        $category        = AccountingType::where('name', 'Equity')->first();
        Account::firstOrCreate([
            'code'                     => 'CAPITAL',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CAPITAL',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CAPITAL',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'DRAWING',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'DRAWING',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'DRAWING',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PERSONAL_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PERSONAL EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PERSONAL EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Cash in Hand')->first();
        $category        = AccountingType::where('name', 'Assets')->first();
        Account::firstOrCreate([
            'code'                     => 'CASH',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CASH',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CASH',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Current Asset')->first();
        $category        = AccountingType::where('name', 'Assets')->first();
        Account::firstOrCreate([
            'code'                     => 'GOODWILL',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'GOODWILL',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'GOODWILL',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'TDS_RECEIVABLE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'TDS RECEIVABLE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'TDS RECEIVABLE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'TCS_RECEIVABLE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'TCS RECEIVABLE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'TCS RECEIVABLE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Current Liability')->first();
        $category        = AccountingType::where('name', 'Liabilities')->first();
        Account::firstOrCreate([
            'code'                     => 'OUTSTANDING_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'OUTSTANDING EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'OUTSTANDING EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SALARY_PAYABLE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SALARY PAYABLE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SALARY PAYABLE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'TDS_PAYABLE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'TDS PAYABLE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'TDS PAYABLE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'TCS_PAYABLE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'TCS PAYABLE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'TCS PAYABLE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Direct Expenses')->first();
        $category        = AccountingType::where('name', 'Expenses')->first();
        Account::firstOrCreate([
            'code'                     => 'CARRIAGE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CARRIAGE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CARRIAGE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'CARRIAGE_ON_PURCHASES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CARRIAGE ON PURCHASES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CARRIAGE ON PURCHASES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'COAL_AND_FUEL',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'COAL & FUEL',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'COAL & FUEL',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'CONSUMED_MATERIAL',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CONSUMED MATERIAL',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CONSUMED MATERIAL',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'FACTORY_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'FACTORY EXPENSES (LIGHTING, POWER ETC.)',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'FACTORY EXPENSES (LIGHTING, POWER ETC.)',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'FREIGHT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'FREIGHT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'FREIGHT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'FREIGHT_ON_PURCHASE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'FREIGHT ON PURCHASE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'FREIGHT ON PURCHASE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'FUEL_AND_POWER',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'FUEL & POWER OF FACTORY',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'FUEL & POWER OF FACTORY',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'GAS_AND_WATER',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'GAS AND WATER',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'GAS AND WATER',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'IMPORT_DUTY',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'IMPORT DUTY',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'IMPORT DUTY',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MANUFACTURING_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MANUFACTURING EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MANUFACTURING EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'OCTROI',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'OCTROI',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'OCTROI',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'OIL',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'OIL',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'OIL',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'POWER_AND_FUEL',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'POWER & FUEL',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'POWER & FUEL',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PRODUCTION_WAGES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PRODUCTION WAGES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PRODUCTION WAGES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'RENT_ON_PURCHASE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'RENT ON PURCHASE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'RENT ON PURCHASE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'TRAIN_FREIGHT_AND_RENT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'TRAIN FREIGHT & RENT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'TRAIN FREIGHT & RENT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'WAGES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'WAGES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'WAGES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'WAGES_ON_PRODUCTION',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'WAGES ON PRODUCTION',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'WAGES ON PRODUCTION',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Fixed Asset')->first();
        $category        = AccountingType::where('name', 'Assets')->first();
        Account::firstOrCreate([
            'code'                     => 'BUILDING',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'BUILDING',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'BUILDING',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'CAR',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CAR',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CAR',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'COMPUTER',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'COMPUTER',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'COMPUTER',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'FURNITURE_AND_FITTING',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'FURNITURE & FITTING',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'FURNITURE & FITTING',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'FURNITURE_AND_FIXTURE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'FURNITURE & FIXTURE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'FURNITURE & FIXTURE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'HORSE_AND_CARTS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'HORSE & CARTS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'HORSE & CARTS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'LAND_AND_BUILDING',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'LAND & BUILDING',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'LAND & BUILDING',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'LEASE_HOLD_BUILDING',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'LEASE HOLD BUILDING',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'LEASE HOLD BUILDING',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'LOOSE_TOOLS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'LOOSE TOOLS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'LOOSE TOOLS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MACHINE_AND_TOOLS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MACHINE & TOOLS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MACHINE & TOOLS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MOTOR_CYCLE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MOTOR CYCLE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MOTOR CYCLE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PLANT_AND_MACHINE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PLANT & MACHINE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PLANT & MACHINE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PURCHASE_OF_NEW_LAND',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PURCHASE OF NEW LAND',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PURCHASE OF NEW LAND',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'REFRIGERATOR',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'REFRIGERATOR',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'REFRIGERATOR',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SHOP',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SHOP',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SHOP',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SHOWROOM / SHOP',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SHOWROOM / SHOP',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SHOWROOM / SHOP',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Indirect Expenses')->first();
        $accounting_type = AccountingType::where('name', 'Expenses')->first();
        Account::firstOrCreate([
            'code'                     => 'ADVERTISEMENT_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'ADVERTISEMENT EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'ADVERTISEMENT EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'HOUSE_RENT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'HOUSE RENT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'HOUSE RENT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'AUDIT_FEES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'AUDIT FEES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'AUDIT FEES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'BAD_DEBTS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'BAD DEBTS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'BAD DEBTS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'BANK_CHARGES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'BANK CHARGES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'BANK CHARGES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'BANK_COMMISSION',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'BANK COMMISSION',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'BANK COMMISSION',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'CAR_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CAR EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CAR EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'CAR_REPAIR',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CAR REPAIR',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CAR REPAIR',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'CARRIAGE_ON_SALES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CARRIAGE ON SALES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CARRIAGE ON SALES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'COMMISSION_PAID',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'COMMISSION PAID',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'COMMISSION PAID',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'DEPRECIATION',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'DEPRECIATION',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'DEPRECIATION',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'DISCOUNT_ALLOWED',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'DISCOUNT ALLOWED',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'DISCOUNT ALLOWED',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'DONATION',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'DONATION',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'DONATION',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'ELECTRICITY_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'ELECTRICITY EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'ELECTRICITY EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'FIRE_INSURANCE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'FIRE INSURANCE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'FIRE INSURANCE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'FREIGHT_ON_SALE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'FREIGHT ON SALE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'FREIGHT ON SALE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'GENERAL_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'GENERAL EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'GENERAL EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'GODOWN_RENT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'GODOWN RENT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'GODOWN RENT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INSURANCE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INSURANCE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INSURANCE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INTEREST_(DR.)',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INTEREST (DR.)',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INTEREST (DR.)',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INTEREST_ON_CAPITAL',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INTEREST ON CAPITAL',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INTEREST ON CAPITAL',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INTEREST_ON_LOAN',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INTEREST ON LOAN',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INTEREST ON LOAN',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'LABOR_CHARGES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'LABOR CHARGES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'LABOR CHARGES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'LEGAL_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'LEGAL EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'LEGAL EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'LIFE_INSURANCE_PREMIUM',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'LIFE INSURANCE PREMIUM',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'LIFE INSURANCE PREMIUM',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'LOSS_BY_DAMAGE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'LOSS BY DAMAGE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'LOSS BY DAMAGE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'LOSS_BY_FIRE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'LOSS BY FIRE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'LOSS BY FIRE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MACHINE_REPAIR',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MACHINE REPAIR',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MACHINE REPAIR',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MANAGER_COMMISSION',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MANAGER COMMISSION',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MANAGER COMMISSION',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MISCELLANEOUS_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MISCELLANEOUS EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MISCELLANEOUS EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MOBILE_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MOBILE EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MOBILE EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MOTOR_CYCLE_REPAIR',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MOTOR CYCLE REPAIR',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MOTOR CYCLE REPAIR',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'OFFICE_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'OFFICE EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'OFFICE EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PACKING_EXP',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PACKING EXPa',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PACKING EXP',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PETROL_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PETROL EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PETROL EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'POSTAGE_AND_TELEGRAM',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'POSTAGE & TELEGRAM',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'POSTAGE & TELEGRAM',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PRINTING_AND_ADVERTISEMENT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PRINTING & ADVERTISEMENT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PRINTING & ADVERTISEMENT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PRINTING_AND_STATIONERY',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PRINTING & STATIONERY',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PRINTING & STATIONERY',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PRINTING,_PAPERS_AND_ADVERTISEMENT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PRINTING, PAPERS & ADVERTISEMENT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PRINTING, PAPERS & ADVERTISEMENT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PROVISION_FOR_BAD_DEBTS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PROVISION FOR BAD DEBTS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PROVISION FOR BAD DEBTS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'RENT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'RENT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'RENT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'REPAIR_AND_RENOVATION',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'REPAIR & RENOVATION',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'REPAIR & RENOVATION',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SALARY',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SALARY',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SALARY',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SALARY_AND_WAGES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SALARY & WAGES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SALARY & WAGES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SHOP_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SHOP EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SHOP EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SHOP_RENT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SHOP RENT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SHOP RENT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SHOWROOM_REPAIR',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SHOWROOM REPAIR',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SHOWROOM REPAIR',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'STABLE_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'STABLE EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'STABLE EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'STAMP_AND_POSTAGE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'STAMP & POSTAGE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'STAMP & POSTAGE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'STATIONERY',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'STATIONERY',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'STATIONERY',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'TELEPHONE_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'TELEPHONE EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'TELEPHONE EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'TRADE_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'TRADE EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'TRADE EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'TRAVELLING_EXPENSES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'TRAVELLING EXPENSES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'TRAVELLING EXPENSES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'VEHICLE_REPAIR',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'VEHICLE REPAIR',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'VEHICLE REPAIR',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'ROUN_OFF',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'ROUN OFF',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'ROUN OFF',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Indirect Income')->first();
        $category        = AccountingType::where('name', 'Income')->first();
        Account::firstOrCreate([
            'code'                     => 'FITTING_CHARGES_RECEIVED',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'FITTING CHARGES RECEIVED',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'FITTING CHARGES RECEIVED',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'BAD_DEBTS_RECEIVED',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'BAD DEBTS RECEIVED',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'BAD DEBTS RECEIVED',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'COMMISSION_RECEIVED',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'COMMISSION RECEIVED',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'COMMISSION RECEIVED',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'DISCOUNT_RECEIVED',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'DISCOUNT RECEIVED',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'DISCOUNT RECEIVED',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INCOME_FROM_REPAIR',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INCOME FROM REPAIR',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INCOME FROM REPAIR',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INCOME_ON_ASSETS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INCOME ON ASSETS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INCOME ON ASSETS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INCOME_ON_INVESTMENTS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INCOME ON INVESTMENTS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INCOME ON INVESTMENTS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INSURANCE_CLAIM',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INSURANCE CLAIM',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INSURANCE CLAIM',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INTEREST_ON_DRAWING',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INTEREST ON DRAWING',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INTEREST ON DRAWING',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INTEREST_RECEIVED_(CR.)',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INTEREST RECEIVED (CR.)',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INTEREST RECEIVED (CR.)',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MISCELLANEOUS_INCOME',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MISCELLANEOUS INCOME',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MISCELLANEOUS INCOME',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'RENT_RECEIVED',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'RENT RECEIVED',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'RENT RECEIVED',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'REPAIRING_CHARGES_RECEIVED',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $accounting_type->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'REPAIRING CHARGES RECEIVED',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'REPAIRING CHARGES RECEIVED',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Investments')->first();
        $category        = AccountingType::where('name', 'Assets')->first();
        Account::firstOrCreate([
            'code'                     => 'INVEST_IN_GOVT._BOND',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INVEST IN GOVT. BOND',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INVEST IN GOVT. BOND',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'INVESTMENT',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'INVESTMENT',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'INVESTMENT',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'MUTUAL_FUND',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'MUTUAL FUND',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'MUTUAL FUND',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SHARES_OR_BONDS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SHARES / BONDS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SHARES / BONDS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Purchase Account')->first();
        $category        = AccountingType::where('name', 'Expenses')->first();
        Account::firstOrCreate([
            'code'                     => 'PURCHASE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PURCHASE',
            'code'                     => 'PURCHASE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PURCHASE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PURCHASE_OF_RAW_MATERIAL',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PURCHASE OF RAW MATERIAL',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PURCHASE OF RAW MATERIAL',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PURCHASE_RETURN',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PURCHASE RETURN',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PURCHASE RETURN',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'PURCHASE_UP/_EX-UP',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'PURCHASE UP/ EX-UP',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'PURCHASE UP/ EX-UP',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'RETURN_OUTWARD',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'RETURN OUTWARD',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'RETURN OUTWARD',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Sales Account')->first();
        $category        = AccountingType::where('name', 'Income')->first();
        Account::firstOrCreate([
            'code'                     => 'RETURN_INWARD',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'RETURN INWARD',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'RETURN INWARD',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SALES',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SALES',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SALES',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SALES_RETURN',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SALES RETURN',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SALES RETURN',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Stock in Hand')->first();
        $category        = AccountingType::where('name', 'Assets')->first();
        Account::firstOrCreate([
            'code'                     => 'CLOSING_STOCK',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CLOSING STOCK',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CLOSING STOCK',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Sundry Creditors')->first();
        $category        = AccountingType::where('name', 'Liabilities')->first();
        Account::firstOrCreate([
            'code'                     => 'BILLS_PAYABLE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'BILLS PAYABLE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'BILLS PAYABLE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'CREDITORS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'CREDITORS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'CREDITORS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SUNDRY_CREDITORS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SUNDRY CREDITORS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SUNDRY CREDITORS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Sundry Debtors')->first();
        $category        = AccountingType::where('name', 'Assets')->first();
        Account::firstOrCreate([
            'code'                     => 'BILLS_RECEIVABLE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'BILLS RECEIVABLE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'BILLS RECEIVABLE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'DEBTORS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'DEBTORS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'DEBTORS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        Account::firstOrCreate([
            'code'                     => 'SUNDRY_DEBTORS',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'SUNDRY DEBTORS',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'SUNDRY DEBTORS',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        $account_type    = MasterType::where('type_name', 'General')->first();
        $account_group   = AccountingGroup::where('name', 'Suspense Account')->first();
        $category        = AccountingType::where('name', 'Equity')->first();
        Account::firstOrCreate([
            'code'                     => 'TRAVELLING_ADVANCE',
        ],[
            'account_type_id'          => $account_type->id,
            'accounting_group_id'      => $account_group->id,
            'account_category_id'      => $category->id,
            'division_id'              => NULL,
            'company_id'               => '1',
            'tax_register_category_id' => '1',
            'name'                     => 'TRAVELLING ADVANCE',
            'settlement_type'          => '',
            'balance_type'             => '',
            'opening_balance'          =>  0.00,
            'print_name'               => 'TRAVELLING ADVANCE',
            'referred_by'              => NULL,
            'account_title_id'         => NULL,
            'credit_limit'             => NULL,
            'status'                   => '1',
            'created_by'               => 1,
            'updated_by'               => 1,
            'created_at'               => date('Y-m-d H:i:s'),
            'updated_at'               => date('Y-m-d H:i:s'),
            'unique_register_no'       => NULL,
            'house_group_id'           => NULL,
            'primary_account'          => 1,
        ]);
        // $account_type    = MasterType::where('type_name', 'General')->first();
        // $account_group   = AccountingGroup::where('name', 'Unsecured Loan')->first();
        // $category        = AccountingType::where('name', 'Equity')->first();
        // Account::create([
        //     'account_type_id'          => $account_type->id,
        //     'accounting_group_id'      => $account_group->id,
        //     'account_category_id'      => $category->id,
        //     'division_id'              => NULL,
        //     'company_id'               => '1',
        //     'tax_register_category_id' => '1',
        //     'name'                     => 'LOAN ON MORTGAGE',
        //     'code'                     => 'LOAN_ON_MORTGAGE',
        //     'settlement_type'          => '',
        //     'balance_type'             => '',
        //     'opening_balance'          =>  0.00,
        //     'print_name'               => 'LOAN ON MORTGAGE',
        //     'referred_by'              => NULL,
        //     'account_title_id'         => NULL,
        //     'credit_limit'             => NULL,
        //     'status'                   => '1',
        //     'created_by'               => 1,
        //     'updated_by'               => 1,
        //     'created_at'               => date('Y-m-d H:i:s'),
        //     'updated_at'               => date('Y-m-d H:i:s'),
        //     'unique_register_no'       => NULL,
        //     'house_group_id'           => NULL
        // ]);
    }
}
