<?php

namespace Database\Seeders;

use App\Models\AddressType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AddressTypesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $address_types = [
            [
                'name'       => 'Bill To Address',
                'code'       => 'BILL_TO_ADDRESS',
                'priority'   => '1',
                'is_default' => '1',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Ship to Address',
                'code'       => 'SHIP_TO_ADDRESS',
                'priority'   => '2',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Dispatch From Address',
                'code'       => 'DISPATCH_FROM_ADDRESS',
                'priority'   => '3',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Godown Address',
                'code'       => 'GODOWN_ADDRESS',
                'priority'   => '4',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Office Address',
                'code'       => 'OFFICE_ADDRESS',
                'priority'   => '5',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Home Address',
                'code'       => 'HOME_ADDRESS',
                'priority'   => '6',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Registered Address',
                'code'       => 'REGISTERED_ADDRESE',
                'priority'   => '7',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Corporate Address',
                'code'       => 'COPORATIVE_ADDRESS',
                'priority'   => '8',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Global Address',
                'code'       => 'GLOBAL_ADDRESS',
                'priority'   => '9',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Branch Address',
                'code'       => 'BRANCH_ADDRESS',
                'priority'   => '10',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
        ];

        // \DB::table('address_types')->insert($address_types);
        foreach ($address_types as $data) {
            AddressType::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
