<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\AnesthesiaType;

class AnesthesiaTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $anesthesia_types = [
            [
                'name'       => 'Analgesics (Pain Relievers)',
                'code'       => 'ANALGESICS_PAIN_RELIEVERS',
                'priority'   => 1,
                'is_default' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Anxiolytics (Sedatives)',
                'code'       => 'ANXIOLYTICS_SEDATIVES',
                'priority'   => 2,
                'is_default' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Local Anesthetics',
                'code'       => 'LOCAL_ANESTHETICS',
                'priority'   => 3,
                'is_default' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'General Anesthetics',
                'code'       => 'GENERAL_ANESTHETICS',
                'priority'   => 4,
                'is_default' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Paralytics (Muscle Relaxants)',
                'code'       => 'PARALYTICS_MUSCLE_RELAXANTS',
                'priority'   => 5,
                'is_default' => 0,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
        ];

        // AnesthesiaType::insert($anesthesia_types);
        foreach ($anesthesia_types as $data) {
            AnesthesiaType::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
