<?php

namespace Database\Seeders;

use App\Models\AppointmentShift;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AppointmentShiftSeederTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // if (\App::environment('local')) {
        //     AppointmentShift::truncate();
        // }

        $appointmentShifts = [
            [
                'name'                      => 'Morning',
                'code'                      => 'MORNING',
                'priority'                  => 1,
                'patient_quantity'          => 25,
                'time_from'                 => '08:00:00',
                'time_to'                   => '11:37:00',
                'gap_between_two_patient'   => 10,
                'serial_prefix'             => 'MO',
                'serial_start_from'         => 1,
                'bg_color'                  => '#1c6a7b',
                'color'                     => '#fafafa'
            ],
            [
                'name'                      => 'Afternoon',
                'code'                      => 'AFTERNOON',
                'priority'                  => 2,
                'patient_quantity'          => 25,
                'time_from'                 => '14:00:00',
                'time_to'                   => '18:00:00',
                'gap_between_two_patient'   => 10,
                'serial_prefix'             => 'AF',
                'serial_start_from'         => 1,
                'bg_color'                  => '#0cc8bf',
                'color'                     => '#f9f5f5'
            ],
            [
                'name'                      => 'Evening',
                'code'                      => 'EVENING',
                'priority'                  => 3,
                'patient_quantity'          => 25,
                'time_from'                 => '18:00:00',
                'time_to'                   => '22:00:00',
                'gap_between_two_patient'   => 10,
                'serial_prefix'             => 'EV',
                'serial_start_from'         => 1,
                'bg_color'                  => '#7893a2',
                'color'                     => '#f1efef'
            ],
        ];

        foreach ($appointmentShifts as $value) {
            AppointmentShift::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }

    }
}
