<?php

namespace Database\Seeders;

use App\Models\BedGroup;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BedGroupTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $BedGroup = [
	        [
				'name'        => 'VIP Ward',
				'code'        => 'VIP_WARD',
				'floor_id'    => '1',
				'description' => 'A palliative or hospice unit is where end-of-life care is provided if you have a life-limiting illness, which may or may not be cancer-related. Hospice and palliative care focus on providing comfort a',
				'priority'    => '1',
				'created_at'  => date('Y-m-d H:i:s'),
				'updated_at'  => date('Y-m-d H:i:s')
	        ],
	        [
				'name'        => 'Private Ward',
				'code'        => 'PRIVATE_WARD',
				'floor_id'    => '4',
				'description' => 'The operating room (OR) is where both inpatient and outpatient surgeries are performed.',
				'priority'    => '2',
				'created_at'  => date('Y-m-d H:i:s'),
				'updated_at'  => date('Y-m-d H:i:s')
	        ],
	        [
				'name'        => 'General Ward Male',
				'code'        => 'GENERAL_WARD_MALE',
				'floor_id'    => '4',
				'description' => '',
				'priority'    => '3',
				'created_at'  => date('Y-m-d H:i:s'),
				'updated_at'  => date('Y-m-d H:i:s')
	        ],
	        [
				'name'        => 'General Ward Female',
				'code'        => 'GENERAL_WARD_FEMALE',
				'floor_id'    => '4',
				'description' => '',
				'priority'    => '4',
				'created_at'  => date('Y-m-d H:i:s'),
				'updated_at'  => date('Y-m-d H:i:s')
	        ],
	        [
				'name'        => 'ICU',
				'code'        => 'ICU',
				'floor_id'    => '3',
				'description' => "The intensive care unit (ICU) is where you're sent if you require close monitoring. The ICU is also referred to as a critical care unit.2 Nurses in the ICU typically have just one or two patients, so",
				'priority'    => '5',
				'created_at'  => date('Y-m-d H:i:s'),
				'updated_at'  => date('Y-m-d H:i:s')
	        ],
	        [
				'name'        => 'NICU',
				'code'        => 'NICU',
				'floor_id'    => '3',
				'description' => "The NICU may be either the neurological intensive care unit or the neonatal intensive care unit, depending on whether the facility treats adults or children. In some facilities, the neurological ICU i",
				'priority'    => '6',
				'created_at'  => date('Y-m-d H:i:s'),
				'updated_at'  => date('Y-m-d H:i:s')
	        ],
	        [
				'name'        => 'NICU',
				'code'        => 'NICU',
				'floor_id'    => '3',
				'description' => "The NICU may be either the neurological intensive care unit or the neonatal intensive care unit, depending on whether the facility treats adults or children. In some facilities, the neurological ICU i",
				'priority'    => '6',
				'created_at'  => date('Y-m-d H:i:s'),
				'updated_at'  => date('Y-m-d H:i:s')
	        ],
	        [
				'name'        => 'AC (Normal)',
				'code'        => 'AC_(NORMAL)',
				'floor_id'    => '2',
				'description' => "",
				'priority'    => '7',
				'created_at'  => date('Y-m-d H:i:s'),
				'updated_at'  => date('Y-m-d H:i:s')
	        ],
	        [
				'name'        => 'Non AC',
				'code'        => 'NON_AC',
				'floor_id'    => '5',
				'description' => "",
				'priority'    => '8',
				'created_at'  => date('Y-m-d H:i:s'),
				'updated_at'  => date('Y-m-d H:i:s')
	        ],

	    ];

        foreach ($BedGroup as $data) {
            BedGroup::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
