<?php

namespace Database\Seeders;

use App\Models\BedType;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BedTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $BedTypes = [
	        [
				'name'       => 'Normal',
				'code'       => 'NORMAL',
				'product_id' => '182',
				'created_at' => date('Y-m-d H:i:s'),
				'updated_at' => date('Y-m-d H:i:s')
	        ],
	        [
				'name'       => 'Standard',
				'code'       => 'STANDARD',
				'product_id' => '181',
				'created_at' => date('Y-m-d H:i:s'),
				'updated_at' => date('Y-m-d H:i:s')
	        ],
	        [
				'name'       => 'VIP',
                'code'       => 'VIP',
				'product_id' => '183',
				'created_at' => date('Y-m-d H:i:s'),
				'updated_at' => date('Y-m-d H:i:s')
	        ],
	    ];

        foreach ($BedTypes as $data) {
            BedType::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
