<?php

namespace Database\Seeders;

use App\Models\BilingInterval;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BillingIntervalTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the MasterType table
         */
        // if (\App::environment('local')) {
        //     BilingInterval::truncate();
        // }

        $types = [
            [
                'biling_interval' => 'Life Time',
                'code'            => 'LIFE_TIME',
                'per_year'        => '1',
                'days'            => '0',
                'lifetime'        => 1,
            ],
            [
                'biling_interval' => 'Monthly',
                'code'            => 'MONTHLY',
                'per_year'        => '12',
                'days'            => '30',
                'lifetime'        => 0,
            ],
            [
                'biling_interval' => 'Quarterly',
                'code'            => 'QUARTERLY',
                'per_year'        => '4',
                'days'            => '90',
                'lifetime'        => 0,
            ],
            [
                'biling_interval' => 'Half Yearly',
                'code'            => 'HALF_YEARLY',
                'per_year'        => '2',
                'days'            => '180',
                'lifetime'        => 0,
            ],
            [
                'biling_interval' => 'Yearly',
                'code'            => 'YEARLY',
                'per_year'        => '1',
                'days'            => '365',
                'lifetime'        => 0,
            ]
        ];

        foreach ($types as $value) {
            BilingInterval::firstOrCreate(
                ['code' => $value['code']],
                $value
            );
        }
    }
}
