<?php

namespace Database\Seeders;

use App\Models\BodyVital;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BodyVitalsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $bodyVitals = [
            [
                'name'       => 'Height',
                'code'       => 'HEIGHT',
                'short_name' => 'Ht',
                'unit'       => '',
                'priority'   => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Weight',
                'code'       => 'WEIGHT',
                'short_name' => 'Wt',
                'unit'       => '',
                'priority'   => 2,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'BMI',
                'code'       => 'BMI',
                'short_name' => 'BMI',
                'unit'       => 'Kg/Mtr^2',
                'priority'   => 3,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Respiratory rate',
                'code'       => 'RESPIRATORY_RATE',
                'short_name' => 'RR',
                'unit'       => '/Min',
                'priority'   => 4,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            // [
            //     'name'       => 'Location',
            //     'code'       => 'LOCATION',
            //     'short_name' => 'Location',
            //     'unit'       => '',
            //     'priority'   => 5,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'O2 Saturation',
            //     'code'       => 'O2_SATURATION',
            //     'short_name' => 'O2 Saturation',
            //     'unit'       => '',
            //     'priority'   => 6,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'Systolic blood pressure',
            //     'code'       => 'SYSTOLIC_BLOOD_PRESSURE',
            //     'short_name' => 'Sys BP',
            //     'unit'       => '',
            //     'priority'   => 7,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'Diastolic blood pressure',
            //     'code'       => 'DIASTOLIC_BLOOD_PRESSURE',
            //     'short_name' => 'Diastolic BP',
            //     'unit'       => '',
            //     'priority'   => 8,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'Diastolic blood pressure',
            //     'code'       => 'DIASTOLIC_BLOOD_PRESSURE',
            //     'short_name' => 'Diastolic BP',
            //     'unit'       => '',
            //     'priority'   => 9,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'Blood Pressure Position',
            //     'code'       => 'BLOOD_PRESSURE_POSITION',
            //     'short_name' => 'BPP',
            //     'unit'       => '',
            //     'priority'   => 10,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'Blood Pressure Source',
            //     'code'       => 'BLOOD_PRESSURE_SOURCE',
            //     'short_name' => 'BPS',
            //     'unit'       => '',
            //     'priority'   => 11,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'Head circumference',
            //     'code'       => 'HEAD_CIRCUMFERENCE',
            //     'short_name' => 'HC',
            //     'unit'       => '',
            //     'priority'   => 12,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'Rh Factor',
            //     'code'       => 'RH_FACTOR',
            //     'short_name' => 'Rh F',
            //     'unit'       => '',
            //     'priority'   => 13,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'LMP',
            //     'code'       => 'LMP',
            //     'short_name' => 'LMP',
            //     'unit'       => '',
            //     'priority'   => 14,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            // [
            //     'name'       => 'EDD',
            //     'code'       => 'EDD',
            //     'short_name' => 'EDD',
            //     'unit'       => '',
            //     'priority'   => 15,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
            [
                'name'       => 'BP',
                'code'       => 'BP',
                'short_name' => 'BP',
                'unit'       => 'mmHg',
                'priority'   => 16,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Pulse',
                'code'       => 'PULSE',
                'short_name' => 'PR',
                'unit'       => '/Min',
                'priority'   => 17,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Temperature',
                'code'       => 'TEMPERATURE',
                'short_name' => 'Temp',
                'unit'       => 'F^0',
                'priority'   => 18,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            // [
            //     'name'       => 'Respiration',
            //     'code'       => 'RESPIRATION',
            //     'short_name' => 'Respiration',
            //     'unit'       => '',
            //     'priority'   => 19,
            //     'created_at' => date('Y-m-d H:i:s'),
            //     'updated_at' => date('Y-m-d H:i:s'),
            // ],
        ];

        // BodyVital::insert($bodyVitals);
        foreach ($bodyVitals as $data) {
            BodyVital::updateOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
