<?php

namespace Database\Seeders;

use App\Models\LibrarySetting\BookClass;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BookClassesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // if (\App::environment('local')) {
        //     BookClass::truncate();
        // }
        $formates = [
            [
                'class_name' => 'Generalities',
                'code'       => 'GENERALITIES',
                'class_no'   => '000',
                'class_type' => 1,
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Bibliography and Library Science',
                'code'          => 'BIBLIOGRAPHY_AND_LIBRARY_SCIENCE',
                'class_no'      => '010',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name' => 'Library and Information Sciences',
                'code'       => 'LIBRARY_AND_INFORMATION_SCIENCES',
                'class_no'   => '020',
                'class_type' => 0,
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'General Encyclopedic Works',
                'code'          => 'GENERAL_ENCYCLOPEDIC_WORKS',
                'class_no'      => '030',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Unassigned',
                'code'          => 'UNASSIGNED',
                'class_no'      => '040',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Magazines, Journals, and Serials',
                'code'          => 'MAGAZINE_JOURNAL_SERIALS',
                'class_no'      => '050',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Associations, Organizations, Museums',
                'code'          => 'ASSOCIATIONS_ORGANIZATIONS_MUSEUMS',
                'class_no'      => '060',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'News Media, Journalism, Publishing',
                'code'          => 'NEWS_MEDIA_JOURNALISM_PUBLISHING',
                'class_no'      => '070',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Quotations',
                'code'          => 'QUOTATIONS',
                'class_no'      => '080',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Manuscripts and Rare Books',
                'code'          => 'MANUSCRIPTS_RARE_BOOKS',
                'class_no'      => '090',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Philosophy and Psychology',
                'code'          => 'PHILOSOPHY_PSYCHOLOGY',
                'class_no'      => '100',
                'class_type'    => 1,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name' => 'Metaphysics',
                'code'       => 'METAPHYSICS',
                'class_no'   => '110',
                'class_type' => 0,
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Epistemology',
                'code'          => 'EPISTEMOLOGY',
                'class_no'      => '120',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Parapsychology and Occultism',
                'code'          => 'PARAPSYCHOLOGY_OCCULTISM',
                'class_no'      => '130',
                'class_type'    => 1,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Philosophical Systems and Points of View',
                'code'          => 'PHILOSOPHICAL_SYSTEMS_AND_POINTS_OF_VIEW',
                'class_no'      => '140',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Psychology',
                'code'          => 'PSYCHOLOGY',
                'class_no'      => '150',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Logic',
                'code'          => 'LOGIC',
                'class_no'      => '160',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Ethics',
                'code'          => 'ETHICS',
                'class_no'      => '170',
                'class_type'    => 1,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Ancient, Medieval, Oriental Philosophy',
                'code'          => 'ANCIENT_MEDIEVAL_ORIENTAL_PHILOSOPHY',
                'class_no'      => '180',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Modern Western Philosophy',
                'code'          => 'MODERN_WESTERN_PHILOSOPHY',
                'class_no'      => '190',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Religion',
                'code'          => 'RELIGION',
                'class_no'      => '200',
                'class_type'    => 1,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Philosophy and Theory of Religion',
                'code'          => 'PHILOSOPHY_AND_THEORY_OF_RELIGION',
                'class_no'      => '210',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'The Bible',
                'code'          => 'THE_BIBLE',
                'class_no'      => '220',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Christianity',
                'code'          => 'CHRISTIANITY',
                'class_no'      => '230',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Christian Practice and Observance',
                'code'          => 'CHRISTIAN_PRACTICE_AND_OBSERVANCE',
                'class_no'      => '240',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Christian Orders and Local Church',
                'code'          => 'CHRISTIAN_ORDERS_AND_LOCAL_CHURCH',
                'class_no'      => '250',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Christian Social and Ecclesiastical Theology',
                'code'          => 'CHRISTIAN_SOCIAL_AND_ECCLESIASTICAL_THEOLOGY',
                'class_no'      => '260',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'History of Christianity',
                'code'          => 'HISTORY_OF_CHRISTIANITY',
                'class_no'      => '270',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Christian Denominations and Sects',
                'code'          => 'CHRISTIAN_DENOMINATIONS_AND_SECTS',
                'class_no'      => '280',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Other Religions',
                'code'          => 'OTHER_RELIGIONS',
                'class_no'      => '290',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Social Sciences',
                'code'          => 'SOCIAL_SCIENCES',
                'class_no'      => '300',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'General Statistics',
                'code'          => 'GENERAL_STATISTICS',
                'class_no'      => '310',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Political Science',
                'code'          => 'POLITICAL_SCIENCE',
                'class_no'      => '320',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Economics',
                'code'          => 'ECONOMICS',
                'class_no'      => '330',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Law',
                'code'          => 'LAW',
                'class_no'      => '340',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Public Administration and Military Science',
                'code'          => 'PUBLIC_ADMINISTRATION_AND_MILITARY_SCIENCE',
                'class_no'      => '350',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Social Problems and Services',
                'code'          => 'SOCIAL_PROBLEMS_AND_SERVICES',
                'class_no'      => '360',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Education',
                'code'          => 'EDUCATION',
                'class_no'      => '370',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Commerce, Communications, Transportation',
                'code'          => 'COMMERCE_COMMUNICATIONS_TRANSPORTATION',
                'class_no'      => '380',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Customs, Etiquette, Folklore',
                'code'          => 'CUSTOMS_ETIQUETTE_FOLKLORE',
                'class_no'      => '390',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Language',
                'code'          => 'LANGUAGE',
                'class_no'      => '400',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Linguistics',
                'code'          => 'LINGUISTICS',
                'class_no'      => '410',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'English and Old English Languages',
                'code'          => 'ENGLISH_AND_OLD_ENGLISH_LANGUAGES',
                'class_no'      => '420',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Germanic Languages',
                'code'          => 'GERMANIC_LANGUAGES',
                'class_no'      => '430',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Romance Languages',
                'code'          => 'ROMANCE_LANGUAGES',
                'class_no'      => '440',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Italian, Romanian, Rhaeto-Romanic',
                'code'          => 'ITALIAN_ROMANIAN_RHAETO_ROMANIC',
                'class_no'      => '450',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Spanish and Portuguese Languages',
                'code'          => 'SPANISH_AND_PORTUGUESE_LANGUAGES',
                'class_no'      => '460',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Italic Latin',
                'code'          => 'ITALIC_LATIN',
                'class_no'      => '470',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Hellenic Languages',
                'code'          => 'HELLENIC_LANGUAGES',
                'class_no'      => '480',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Other Languages',
                'code'          => 'OTHER_LANGUAGES',
                'class_no'      => '490',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Natural Sciences and Mathematics',
                'code'          => 'NATURAL_SCIENCES_AND_MATHEMATICS',
                'class_no'      => '500',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Mathematics',
                'code'          => 'MATHEMATICS',
                'class_no'      => '510',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Astronomy',
                'code'          => 'ASTRONOMY',
                'class_no'      => '520',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Physics',
                'code'          => 'PHYSICS',
                'class_no'      => '530',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Chemistry',
                'code'          => 'CHEMISTRY',
                'class_no'      => '540',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Earth Sciences',
                'code'          => 'EARTH SCIENCES',
                'class_no'      => '550',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Paleontology; Paleozoology',
                'code'          => 'PALEONTOLOGY_PALEOZOOLOGY',
                'class_no'      => '560',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Life Sciences',
                'code'          => 'LIFE_SCIENCES',
                'class_no'      => '570',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Botanical Sciences',
                'code'          => 'BOTANICAL_SCIENCES',
                'class_no'      => '580',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Zoological Sciences',
                'code'          => 'ZOOLOGICAL_SCIENCES',
                'class_no'      => '590',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Technology (Applied Sciences)',
                'code'          => 'TECHNOLOGY_APPLIED_SCIENCES',
                'class_no'      => '600',
                'class_type'    => 1,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Medicine and Health',
                'code'          => 'MEDICINE_AND_HEALTH',
                'class_no'      => '610',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Engineering',
                'code'          => 'ENGINEERING',
                'class_no'      => '620',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Agriculture',
                'code'          => 'AGRICULTURE',
                'class_no'      => '630',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Home Economics',
                'code'          => 'HOME_ECONOMICS',
                'class_no'      => '640',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Management and Public Relations',
                'code'          => 'MANAGEMENT_AND_PUBLIC_RELATIONS',
                'class_no'      => '650',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Chemical Engineering',
                'code'          => 'CHEMICAL_ENGINEERING',
                'class_no'      => '660',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Manufacturing',
                'code'          => 'MANUFACTURING',
                'class_no'      => '670',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Manufacture for Specific Uses',
                'code'          => 'MANUFACTURE_FOR_SPECIFIC_USES',
                'class_no'      => '680',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Building',
                'code'          => 'BUILDING',
                'class_no'      => '690',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Arts and Recreation',
                'code'          => 'ARTS_AND_RECREATION',
                'class_no'      => '700',
                'class_type'    => 1,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Civic and Landscape Art',
                'code'          => 'CIVIC_AND_LANDSCAPE_ART',
                'class_no'      => '710',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Architecture',
                'code'          => 'ARCHITECTURE',
                'class_no'      => '720',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Plastic Arts; Sculpture',
                'code'          => 'PLASTIC_ARTS_SCULPTURE',
                'class_no'      => '730',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Graphic Arts and Decorative Arts',
                'code'          => 'GRAPHIC_ARTS_AND_DECORATIVE_ARTS',
                'class_no'      => '740',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Painting and Paintings',
                'code'          => 'PAINTING_AND_PAINTINGS',
                'class_no'      => '750',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Printmaking and Prints',
                'code'          => 'PRINTMAKING_AND_PRINTS',
                'class_no'      => '760',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Photography and Photographs',
                'code'          => 'PHOTOGRAPHY_AND_PHOTOGRAPHS',
                'class_no'      => '770',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Music',
                'code'          => 'MUSIC',
                'class_no'      => '780',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Recreational and Performing Arts',
                'code'          => 'RECREATIONAL_PERFORMING_ARTS',
                'class_no'      => '790',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Literature',
                'code'          => 'LITERATURE',
                'class_no'      => '800',
                'class_type'    => 1,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'American Literature in English',
                'code'          => 'AMERICAN_LITERATURE_IN_ENGLISH',
                'class_no'      => '810',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'English and Old English Literatures',
                'code'          => 'ENGLISH_AND_OLD_ENGLISH_LITERATURES',
                'class_no'      => '820',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Literatures of Germanic Languages',
                'code'          => 'LITERATURES_OF_GERMANIC_LANGUAGES',
                'class_no'      => '830',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Literatures of Romance Languages',
                'code'          => 'LITERATURES_OF_ROMANC_LANGUAGES',
                'class_no'      => '840',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Italian, Romanian, Rhaeto-Romanic Lit.',
                'code'          => 'ITALIAN__ROMANIAN__RHAETO_ROMANIC_LIT',
                'class_no'      => '850',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Spanish and Portuguese Literature',
                'code'          => 'SPANISH_AND_PORTUGUESE_LITERATURE',
                'class_no'      => '860',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Italic Latin Literature',
                'code'          => 'ITALIC_LATIN_LITERATURE',
                'class_no'      => '870',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Hellenic Literature',
                'code'          => 'HELLENIC_LITERATURE',
                'class_no'      => '880',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Literatures of Other Languages',
                'code'          => 'LITERATURES_OF_OTHER_LANGUAGES',
                'class_no'      => '890',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'History and Geography',
                'code'          => 'HISTORY_AND_GEOGRAPHY',
                'class_no'      => '900',
                'class_type'    => 1,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Geography and Travel',
                'code'          => 'GEOGRAPHY_AND_TRAVEL',
                'class_no'      => '910',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Biography and Genealogy',
                'code'          => 'BIOGRAPHY_AND_GENEALOGY',
                'class_no'      => '920',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Ancient History',
                'code'          => 'ANCIENT_HISTORY',
                'class_no'      => '930',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Europe History',
                'code'          => 'EUROPE_HISTORY',
                'class_no'      => '940',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Asia History',
                'code'          => 'ASIA_HISTORY',
                'class_no'      => '950',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Africa History',
                'code'          => 'AFRICA_HISTORY',
                'class_no'      => '960',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'North America History',
                'code'          => 'NORTH_AMERICA_HISTORY',
                'class_no'      => '970',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'South America History',
                'code'          => 'SOUTH_AMERICA_HISTORY',
                'class_no'      => '980',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'class_name'    => 'Oceania History',
                'code'          => 'OCEANIA_HISTORY',
                'class_no'      => '990',
                'class_type'    => 0,
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],

        ];

        foreach ($formates as $data) {
            BookClass::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
