<?php

namespace Database\Seeders;

use App\Models\LibrarySetting\BookFormates;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BookFormateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        // if (\App::environment('local')) {
        //     BookFormates::truncate();
        // }


        $formates = [
            [
                'formate_name' => 'Paperback',
                'code'         => 'PAPERBACK',
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'formate_name'  => 'Hardcover',
                'code'          => 'HARDCOVER',
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'formate_name'  => 'E-Book',
                'code'          => 'E_BOOK',
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
            [
                'formate_name'  => 'Audio Book',
                'code'          => 'AUDIO_BOOK',
                'status'        => '1',
                'created_at'    => date('Y-m-d H:i:s'),
                'updated_at'    => date('Y-m-d H:i:s'),
            ],
        ];

        foreach ($formates as $data) {
            BookFormates::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
