<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Building;
use Illuminate\Support\Facades\Auth;

class BuildingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $Building =
            [
                [
                    'name'        => 'Main building',
                    'code'        => 'MAIN_BUILDING',
                    'no_of_floor' => 5,
                    'status'      => '1',
                    'default'     => '1',
                    'priority'    => 1,
                    'created_at'  => now(),
                    'updated_at'  => now(),
                ],
            ];
        foreach ($Building as $data) {
            Building::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
