<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\BusinessDivision;

class BusinessDivissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $divisions = [
            [
                'name'       => 'General',
                'code'       => 'GENERAL',
                'priority'   => '1',
                'is_default' => '1',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Pathology',
                'code'       => 'PATHOLOGY',
                'priority'   => '2',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Out Patient Department',
                'code'       => 'OUT_PATIENT_DEPARTMENT',
                'priority'   => '3',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'In Patient Department',
                'code'       => 'IN_PATIENT_DEPARTMENT',
                'priority'   => '4',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Pharmacy',
                'code'       => 'PHARMACY',
                'priority'   => '5',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Radiology',
                'code'       => 'RADIOLOGY',
                'priority'   => '6',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Bed Charges',
                'code'       => 'BED_CHARGES',
                'priority'   => '7',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Blood Component Issue',
                'code'       => 'BLOOD_COMPONENT_ISSUE',
                'priority'   => '8',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Occupational therapy',
                'code'       => 'OCCUPATIONAL_THERAPY',
                'priority'   => '9',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Cardiology',
                'code'       => 'CARDIOLOGY',
                'priority'   => '9',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Doctor Fees',
                'code'       => 'DOCTOR_FEES',
                'priority'   => '10',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Equipment Charges',
                'code'       => 'EQUIPMENT_CHARGES',
                'priority'   => '10',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Hospital Service',
                'code'       => 'HOSPITAL_SERVICE',
                'priority'   => '11',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Laboratory',
                'code'       => 'LABORATORY',
                'priority'   => '12',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Operation Theater',
                'code'       => 'OPERATION_THEATER',
                'priority'   => '13',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Pharmacy',
                'code'       => 'PHARMACY',
                'priority'   => '14',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Procedure',
                'code'       => 'PROCEDURE',
                'priority'   => '15',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'name'       => 'Service Charges',
                'code'       => 'SERVICE_CHARGES',
                'priority'   => '15',
                'is_default' => '0',
                'status'     => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
        ];

        foreach ($divisions as $data) {
            BusinessDivision::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
