<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Company;
use App\Models\CompanyAddress;
use App\Models\Currency;
use App\Models\DateFormat;
use App\Models\Language;
use App\Models\TimeFormat;
use App\Models\Timezone;

class CompaniesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $date_format    = DateFormat::where('format', 'd-m-Y')->first();
        $time_zone      = Timezone::where('name', 'Asia/Kolkata')->first();
        $time_format    = TimeFormat::where('time_format_name', 'g:i A')->first();
        $language       = Language::where('name', 'English')->first();
        $currency       = Currency::where('currency', 'Indian Rupee')->where('is_default', '1')->first();

        $companyData = Company::latest()->first();

        if (empty($companyData)) {

            $company = [
                'name'           => 'Meta Mint Private Limited',
                'email'          => 'info@metamintindia.com',
                'code'           => 'META_MINT_PRIVATE_LIMITED',
                'branch_code'    => '',
                'office_type'    => 'head_office',
                'mobile_number'  => '',
                'phone_number'   => '',
                'whatsapp_no'    => null,
                'logo'           => '',
                'status'         => '1',
                'is_default'     => '1',
                'deleted_at'     => null,
                'created_at'     => date('Y-m-d H:i:s'),
                'updated_at'     => date('Y-m-d H:i:s'),
                'date_format'    => $date_format->format,
                'time_format'    => $time_format->time_format_name,
                'time_zone'      => $time_zone->id,
                'language_id'    => $language->id,
                'currency_id'    => $currency->id,
            ];

            $company =   Company::firstOrCreate(
                ['id' => 1],
                $company
            );

            $company_address = [
                'company_id'         => $company->id,
                'address_type_id'    => 5,
                'address_1'          => 'India',
                'country_id'         => '101',
                'state_id'           => 10,
                'city_id'            => 706,
                'is_default'         => 1,
                'priority'           => 1,
            ];

            CompanyAddress::firstOrCreate($company_address);
        }
    }
}
