<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CompanyImage;

class CompanyImagesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $images = [
			[
				'company_id' => '1',
				'image_url'  => 'company-documents/bpcLpXbXjqrpDidV5jUV0eHvGxNQ3KhAqK9B4yzF.png',
				'image_type' => 'logo',
				'height'     => '150',
				'width'      => '300',
				'priority'   => '1',
				'status'     => '1'
            ],
			[
				'company_id' => '1',
				'image_url'  => 'company-documents/VOed0clztpX2ZPoJWgO4kfxvFhGpO11OH78q4RmW.jpg',
				'image_type' => 'footer',
				'height'     => '130',
				'width'      => '957',
				'priority'   => '2',
				'status'     => '1'
            ],
			[
				'company_id' => '1',
				'image_url'  => 'company-documents/iejBZtvmjnXS4sEaXvLYNj0qI1YNp6eMkUIbqIo7.jpg',
				'image_type' => 'header',
				'height'     => '130',
				'width'      => '957',
				'priority'   => '3',
				'status'     => '1'
            ]
        ];

        foreach ($images as $data) {
            CompanyImage::updateOrCreate(
				[
					'image_type' => $data['image_type'],
					'company_id' => $data['company_id']
				],
                [
                	'image_url'  => $data['image_url'],
					'height'      => $data['height'],
					'width'		  => $data['width'],
					'priority'	  => $data['priority'],
					'status'	  => $data['status']
				]
            );
        }
    }
}
