<?php

namespace Database\Seeders;

use App\Models\Country;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CountriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the countries table
         */
        // if (\App::environment('local')) {
        //     \DB::table('countries')->truncate();
        // }

        $countries = [
            [
                'id'                         => 1,
                'name'                       => 'Afghanistan',
                'code'                       => 'AF',
                'capital'                    => '',
                'gsm_code'                   => '93',
                'currency_fullname'          => 'Afghan afghani',
                'currency_short_name'        => 'Pul',
                'currency_symbol'            => 'AFN',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '21',
                'financial_year_start_month' => '12',
                'financial_year_end_date'    => '20',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 2,
                'name'                       => 'Albania',
                'code'                       => 'AL',
                'capital'                    => '',
                'gsm_code'                   => '355',
                'currency_fullname'          => 'Albanian lek',
                'currency_short_name'        => '',
                'currency_symbol'            => 'ALL',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'Y-m-d',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 3,
                'name'                       => 'Algeria',
                'code'                       => 'DZ',
                'capital'                    => '',
                'gsm_code'                   => '213',
                'currency_fullname'          => 'Algerian dinar',
                'currency_short_name'        => 'Santeem',
                'currency_symbol'            => 'DZD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 4,
                'name'                => 'American Samoa',
                'code'                => 'AS',
                'capital'             => '',
                'gsm_code'            => '-683',
                'currency_fullname'   => 'US Dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'USD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 5,
                'name'                       => 'Andorra',
                'code'                       => 'AD',
                'capital'                    => '',
                'gsm_code'                   => '376',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'Y-m-d',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 6,
                'name'                       => 'Angola',
                'code'                       => 'AO',
                'capital'                    => '',
                'gsm_code'                   => '244',
                'currency_fullname'          => 'Angolan Kwanza',
                'currency_short_name'        => '',
                'currency_symbol'            => 'AOA',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 7,
                'name'                => 'Anguilla',
                'code'                => 'AI',
                'capital'             => '',
                'gsm_code'            => '-263',
                'currency_fullname'   => 'Eastern Caribbean dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'XCD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'Y-m-d',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 8,
                'name'                => 'Antarctica',
                'code'                => 'AQ',
                'capital'             => '',
                'gsm_code'            => '672',
                'currency_fullname'   => 'Eastern Caribbean dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'XCD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'Y-m-d',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 9,
                'name'                      => 'Antigua And Barbuda',
                'code'                      => 'AG',
                'capital'                   => '',
                'gsm_code'                  => '-267',
                'currency_fullname'         => 'Eastern Caribbean dollar',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'XCD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'Y-m-d',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 10,
                'name'                       => 'Argentina',
                'code'                       => 'AR',
                'capital'                    => '',
                'gsm_code'                   => '54',
                'currency_fullname'          => 'Argentine peso',
                'currency_short_name'        => 'Centavo',
                'currency_symbol'            => 'ARS',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 11,
                'name'                       => 'Armenia',
                'code'                       => 'AM',
                'capital'                    => '',
                'gsm_code'                   => '374',
                'currency_fullname'          => 'Armenian Dram',
                'currency_short_name'        => '',
                'currency_symbol'            => 'AMD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'Y-m-d',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 12,
                'name'                => 'Aruba',
                'code'                => 'AW',
                'capital'             => '',
                'gsm_code'            => '297',
                'currency_fullname'   => 'Aruban Guilder',
                'currency_short_name' => '',
                'currency_symbol'     => 'AWG',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'Y-m-d',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 13,
                'name'                      => 'Australia',
                'code'                      => 'AU',
                'capital'                   => '',
                'gsm_code'                  => '61',
                'currency_fullname'         => 'Australian dollar',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'AUD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                   => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 14,
                'name'                       => 'Austria',
                'code'                       => 'AT',
                'capital'                    => '',
                'gsm_code'                   => '43',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'Y-m-d',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 15,
                'name'                       => 'Azerbaijan',
                'code'                       => 'AZ',
                'capital'                    => '',
                'gsm_code'                   => '994',
                'currency_fullname'          => 'Azerbaijan New Manat',
                'currency_short_name'        => '',
                'currency_symbol'            => 'AZN',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'Y-m-d',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 16,
                'name'                      => 'Bahamas The',
                'code'                      => 'BS',
                'capital'                   => '',
                'gsm_code'                  => '-241',
                'currency_fullname'         => 'Bahamian Dollar',
                'currency_short_name'       => '',
                'currency_symbol'           => 'BSD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                   => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 17,
                'name'                       => 'Bahrain',
                'code'                       => 'BH',
                'capital'                    => '',
                'gsm_code'                   => '973',
                'currency_fullname'          => 'Bahraini Dinar',
                'currency_short_name'        => '',
                'currency_symbol'            => 'BHD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'Y-m-d',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 18,
                'name'                      => 'Bangladesh',
                'code'                      => 'BD',
                'capital'                   => '',
                'gsm_code'                  => '880',
                'currency_fullname'         => 'Bangladeshi Taka',
                'currency_short_name'       => '',
                'currency_symbol'           => 'BDT',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                   => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 19,
                'name'                      => 'Barbados',
                'code'                      => 'BB',
                'capital'                   => '',
                'gsm_code'                  => '-245',
                'currency_fullname'         => 'Barbados Dollar',
                'currency_short_name'       => '',
                'currency_symbol'           => 'BBD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'Y-m-d',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 20,
                'name'                       => 'Belarus',
                'code'                       => 'BY',
                'capital'                    => '',
                'gsm_code'                   => '375',
                'currency_fullname'          => 'Belarussian Ruble',
                'currency_short_name'        => '',
                'currency_symbol'            => 'BYR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 21,
                'name'                       => 'Belgium',
                'code'                       => 'BE',
                'capital'                    => '',
                'gsm_code'                   => '32',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'Y-m-d',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 22,
                'name'                      => 'Belize',
                'code'                      => 'BZ',
                'capital'                   => '',
                'gsm_code'                  => '501',
                'currency_fullname'         => 'Belize Dollar',
                'currency_short_name'       => '',
                'currency_symbol'           => 'BZD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 23,
                'name'                       => 'Benin',
                'code'                       => 'BJ',
                'capital'                    => '',
                'gsm_code'                   => '229',
                'currency_fullname'          => 'West African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XOF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 24,
                'name'                => 'Bermuda',
                'code'                => 'BM',
                'capital'             => '',
                'gsm_code'            => '-440',
                'currency_fullname'   => 'Bermudian Dollar',
                'currency_short_name' => '',
                'currency_symbol'     => 'BMD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 25,
                'name'                      => 'Bhutan',
                'code'                      => 'BT',
                'capital'                   => '',
                'gsm_code'                  => '975',
                'currency_fullname'         => 'Bhutan Ngultrum',
                'currency_short_name'       => '',
                'currency_symbol'           => 'BTN',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                   => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 26,
                'name'                       => 'Bolivia',
                'code'                       => 'BO',
                'capital'                    => '',
                'gsm_code'                   => '591',
                'currency_fullname'          => 'Boliviano',
                'currency_short_name'        => '',
                'currency_symbol'            => 'BOB',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 27,
                'name'                       => 'Bosnia and Herzegovina',
                'code'                       => 'BA',
                'capital'                    => '',
                'gsm_code'                   => '387',
                'currency_fullname'          => 'Marka',
                'currency_short_name'        => '',
                'currency_symbol'            => 'BAM',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 28,
                'name'                      => 'Botswana',
                'code'                      => 'BW',
                'capital'                   => '',
                'gsm_code'                  => '267',
                'currency_fullname'         => 'Botswana Pula',
                'currency_short_name'       => '',
                'currency_symbol'           => 'BWP',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 29,
                'name'                => 'Bouvet Island',
                'code'                => 'BV',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => 'Norwegian Krone',
                'currency_short_name' => '',
                'currency_symbol'     => 'NOK',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 30,
                'name'                       => 'Brazil',
                'code'                       => 'BR',
                'capital'                    => '',
                'gsm_code'                   => '55',
                'currency_fullname'          => 'real',
                'currency_short_name'        => 'Centavo',
                'currency_symbol'            => 'BRL',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 31,
                'name'                => 'British Indian Ocean Territory',
                'code'                => 'IO',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => 'US Dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'USD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 32,
                'name'                => 'Brunei',
                'code'                => 'BN',
                'capital'             => '',
                'gsm_code'            => '673',
                'currency_fullname'   => 'Brunei Dollar',
                'currency_short_name' => '',
                'currency_symbol'     => 'BND',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 33,
                'name'                       => 'Bulgaria',
                'code'                       => 'BG',
                'capital'                    => '',
                'gsm_code'                   => '359',
                'currency_fullname'          => 'Bulgarian Lev',
                'currency_short_name'        => '',
                'currency_symbol'            => 'BGN',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 34,
                'name'                       => 'Burkina Faso',
                'code'                       => 'BF',
                'capital'                    => '',
                'gsm_code'                   => '226',
                'currency_fullname'          => 'West African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XOF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 35,
                'name'                       => 'Burundi',
                'code'                       => 'BI',
                'capital'                    => '',
                'gsm_code'                   => '257',
                'currency_fullname'          => 'Burundi Franc',
                'currency_short_name'        => '',
                'currency_symbol'            => 'BIF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 36,
                'name'                       => 'Cambodia',
                'code'                       => 'KH',
                'capital'                    => '',
                'gsm_code'                   => '855',
                'currency_fullname'          => 'Kampuchean Riel',
                'currency_short_name'        => '',
                'currency_symbol'            => 'KHR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 37,
                'name'                       => 'Cameroon',
                'code'                       => 'CM',
                'capital'                    => '',
                'gsm_code'                   => '237',
                'currency_fullname'          => 'Central African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XAF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 38,
                'name'                      => 'Canada',
                'code'                      => 'CA',
                'capital'                   => '',
                'gsm_code'                  => '1',
                'currency_fullname'         => 'Canadian dollar',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'CAD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 39,
                'name'                       => 'Cape Verde',
                'code'                       => 'CV',
                'capital'                    => '',
                'gsm_code'                   => '238',
                'currency_fullname'          => '',
                'currency_short_name'        => '',
                'currency_symbol'            => '',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 40,
                'name'                => 'Cayman Islands',
                'code'                => 'KY',
                'capital'             => '',
                'gsm_code'            => '-344',
                'currency_fullname'   => 'Cayman Islands Dollar',
                'currency_short_name' => '',
                'currency_symbol'     => 'KYD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 41,
                'name'                       => 'Central African Republic',
                'code'                       => 'CF',
                'capital'                    => '',
                'gsm_code'                   => '236',
                'currency_fullname'          => 'Central African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XAF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 42,
                'name'                       => 'Chad',
                'code'                       => 'TD',
                'capital'                    => '',
                'gsm_code'                   => '235',
                'currency_fullname'          => 'Central African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XAF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 43,
                'name'                       => 'Chile',
                'code'                       => 'CL',
                'capital'                    => '',
                'gsm_code'                   => '56',
                'currency_fullname'          => 'Chilean Peso',
                'currency_short_name'        => '',
                'currency_symbol'            => 'CLP',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 44,
                'name'                       => 'China',
                'code'                       => 'CN',
                'capital'                    => '',
                'gsm_code'                   => '86',
                'currency_fullname'          => 'yuan',
                'currency_short_name'        => 'Fen',
                'currency_symbol'            => 'CNY',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 45,
                'name'                => 'Christmas Island',
                'code'                => 'CX',
                'capital'             => '',
                'gsm_code'            => '53',
                'currency_fullname'   => 'Australian dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'AUD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 46,
                'name'                => 'Cocos (Keeling) Islands',
                'code'                => 'CC',
                'capital'             => '',
                'gsm_code'            => '61',
                'currency_fullname'   => 'Australian dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'AUD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 47,
                'name'                       => 'Colombia',
                'code'                       => 'CO',
                'capital'                    => '',
                'gsm_code'                   => '57',
                'currency_fullname'          => 'Colombian Peso',
                'currency_short_name'        => '',
                'currency_symbol'            => 'COP',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 48,
                'name'                       => 'Comoros',
                'code'                       => 'KM',
                'capital'                    => '',
                'gsm_code'                   => '269',
                'currency_fullname'          => 'Comoros Franc',
                'currency_short_name'        => '',
                'currency_symbol'            => 'KMP',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 49,
                'name'                       => 'Congo',
                'code'                       => 'CG',
                'capital'                    => '',
                'gsm_code'                   => '242',
                'currency_fullname'          => 'Central African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XAF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 50,
                'name'                => 'Congo The Democratic Republic Of The',
                'code'                => 'CD',
                'capital'             => '',
                'gsm_code'            => '243',
                'currency_fullname'   => 'Francs',
                'currency_short_name' => '',
                'currency_symbol'     => 'CDF',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 51,
                'name'                => 'Cook Islands',
                'code'                => 'CK',
                'capital'             => '',
                'gsm_code'            => '682',
                'currency_fullname'   => 'New Zealand dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'NZD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 52,
                'name'                       => 'Costa Rica',
                'code'                       => 'CR',
                'capital'                    => '',
                'gsm_code'                   => '506',
                'currency_fullname'          => 'Costa Rican Colon',
                'currency_short_name'        => '',
                'currency_symbol'            => 'CRC',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 53,
                'name'                => 'Cote D\'Ivoire (Ivory Coast)',
                'code'                => 'CI',
                'capital'             => '',
                'gsm_code'            => '225',
                'currency_fullname'   => '',
                'currency_short_name' => '',
                'currency_symbol'     => '',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 54,
                'name'                       => 'Croatia (Hrvatska)',
                'code'                       => 'HR',
                'capital'                    => '',
                'gsm_code'                   => '385',
                'currency_fullname'          => 'Croatian Kuna',
                'currency_short_name'        => '',
                'currency_symbol'            => 'HRK',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 55,
                'name'                       => 'Cuba',
                'code'                       => 'CU',
                'capital'                    => '',
                'gsm_code'                   => '53',
                'currency_fullname'          => 'Cuban Peso',
                'currency_short_name'        => '',
                'currency_symbol'            => 'CUP',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 56,
                'name'                       => 'Cyprus',
                'code'                       => 'CY',
                'capital'                    => '',
                'gsm_code'                   => '357',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 57,
                'name'                       => 'Czech Republic',
                'code'                       => 'CZ',
                'capital'                    => '',
                'gsm_code'                   => '420',
                'currency_fullname'          => '',
                'currency_short_name'        => '',
                'currency_symbol'            => '',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 58,
                'name'                       => 'Denmark',
                'code'                       => 'DK',
                'capital'                    => '',
                'gsm_code'                   => '45',
                'currency_fullname'          => 'Danish krone',
                'currency_short_name'        => 'Øre',
                'currency_symbol'            => 'DKK',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 59,
                'name'                       => 'Djibouti',
                'code'                       => 'DJ',
                'capital'                    => '',
                'gsm_code'                   => '253',
                'currency_fullname'          => 'Djibouti Franc',
                'currency_short_name'        => '',
                'currency_symbol'            => 'DJF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 60,
                'name'                      => 'Dominica',
                'code'                      => 'DM',
                'capital'                   => '',
                'gsm_code'                  => '-766',
                'currency_fullname'         => 'Eastern Caribbean dollar',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'XCD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                   => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 61,
                'name'                       => 'Dominican Republic',
                'code'                       => 'DO',
                'capital'                    => '',
                'gsm_code'                   => '+1-809 and +1-829?',
                'currency_fullname'          => 'Dominican Peso',
                'currency_short_name'        => '',
                'currency_symbol'            => 'DOP',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 62,
                'name'                => 'East Timor',
                'code'                => 'TP',
                'capital'             => '',
                'gsm_code'            => '670',
                'currency_fullname'   => '',
                'currency_short_name' => '',
                'currency_symbol'     => '',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 63,
                'name'                       => 'Ecuador',
                'code'                       => 'EC',
                'capital'                    => '',
                'gsm_code'                   => '593',
                'currency_fullname'          => 'Ecuador Sucre',
                'currency_short_name'        => '',
                'currency_symbol'            => 'ECS',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 64,
                'name'                      => 'Egypt',
                'code'                      => 'EG',
                'capital'                   => '',
                'gsm_code'                  => '20',
                'currency_fullname'         => 'Egyptian pound',
                'currency_short_name'       => 'Piastre',
                'currency_symbol'           => 'EGP',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                   => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 65,
                'name'                       => 'El Salvador',
                'code'                       => 'SV',
                'capital'                    => '',
                'gsm_code'                   => '503',
                'currency_fullname'          => 'El Salvador Colon',
                'currency_short_name'        => '',
                'currency_symbol'            => 'SVC',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 66,
                'name'                       => 'Equatorial Guinea',
                'code'                       => 'GQ',
                'capital'                    => '',
                'gsm_code'                   => '240',
                'currency_fullname'          => 'Central African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XAF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 67,
                'name'                       => 'Eritrea',
                'code'                       => 'ER',
                'capital'                    => '',
                'gsm_code'                   => '291',
                'currency_fullname'          => 'Eritrean Nakfa',
                'currency_short_name'        => '',
                'currency_symbol'            => 'ERN',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 68,
                'name'                       => 'Estonia',
                'code'                       => 'EE',
                'capital'                    => '',
                'gsm_code'                   => '372',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 69,
                'name'                       => 'Ethiopia',
                'code'                       => 'ET',
                'capital'                    => '',
                'gsm_code'                   => '251',
                'currency_fullname'          => 'Ethiopian Birr',
                'currency_short_name'        => '',
                'currency_symbol'            => 'ETB',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '08',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '07',
                'financial_year_end_month'   => '07',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 70,
                'name'                => 'External Territories of Australia',
                'code'                => 'XA',
                'capital'             => null,
                'gsm_code'            => null,
                'currency_fullname'   => null,
                'currency_short_name' => null,
                'currency_symbol'     => null,
                'priority'            => 1,
                'sale_tax_type'       => null,
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 71,
                'name'                => 'Falkland Islands',
                'code'                => 'FK',
                'capital'             => '',
                'gsm_code'            => '500',
                'currency_fullname'   => 'Falkland Islands Pound',
                'currency_short_name' => '',
                'currency_symbol'     => 'FKP',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 72,
                'name'                => 'Faroe Islands',
                'code'                => 'FO',
                'capital'             => '',
                'gsm_code'            => '298',
                'currency_fullname'   => 'Danish krone',
                'currency_short_name' => 'Øre',
                'currency_symbol'     => 'DKK',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 73,
                'name'                       => 'Fiji Islands',
                'code'                       => 'FJ',
                'capital'                    => '',
                'gsm_code'                   => '679',
                'currency_fullname'          => 'Fiji Dollar',
                'currency_short_name'        => '',
                'currency_symbol'            => 'FJD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 74,
                'name'                       => 'Finland',
                'code'                       => 'FI',
                'capital'                    => '',
                'gsm_code'                   => '358',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 75,
                'name'                       => 'France',
                'code'                       => 'FR',
                'capital'                    => '',
                'gsm_code'                   => '33',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 76,
                'name'                => 'French Guiana',
                'code'                => 'GF',
                'capital'             => '',
                'gsm_code'            => '594',
                'currency_fullname'   => 'Euro',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'EUR',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 77,
                'name'                => 'French Polynesia',
                'code'                => 'PF',
                'capital'             => '',
                'gsm_code'            => '689',
                'currency_fullname'   => 'CFP franc',
                'currency_short_name' => 'Centime',
                'currency_symbol'     => 'XPF',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 78,
                'name'                => 'French Southern Territories',
                'code'                => 'TF',
                'capital'             => '',
                'gsm_code'            => null,
                'currency_fullname'   => 'Euro',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'EUR',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 79,
                'name'                       => 'Gabon',
                'code'                       => 'GA',
                'capital'                    => '',
                'gsm_code'                   => '241',
                'currency_fullname'          => 'Central African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XAF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 80,
                'name'                       => 'Gambia The',
                'code'                       => 'GM',
                'capital'                    => '',
                'gsm_code'                   => '220',
                'currency_fullname'          => 'Gambian Dalasi',
                'currency_short_name'        => '',
                'currency_symbol'            => 'GMD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 81,
                'name'                       => 'Georgia',
                'code'                       => 'GE',
                'capital'                    => '',
                'gsm_code'                   => '995',
                'currency_fullname'          => 'Georgian Lari',
                'currency_short_name'        => '',
                'currency_symbol'            => 'GEL',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 82,
                'name'                       => 'Germany',
                'code'                       => 'DE',
                'capital'                    => '',
                'gsm_code'                   => '49',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 83,
                'name'                       => 'Ghana',
                'code'                       => 'GH',
                'capital'                    => '',
                'gsm_code'                   => '233',
                'currency_fullname'          => 'Ghana Cedi',
                'currency_short_name'        => 'Pesewa',
                'currency_symbol'            => 'GHS',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 84,
                'name'                => 'Gibraltar',
                'code'                => 'GI',
                'capital'             => '',
                'gsm_code'            => '350',
                'currency_fullname'   => 'Gibraltar Pound',
                'currency_short_name' => '',
                'currency_symbol'     => 'GIP',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 85,
                'name'                       => 'Greece',
                'code'                       => 'GR',
                'capital'                    => '',
                'gsm_code'                   => '30',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 86,
                'name'                => 'Greenland',
                'code'                => 'GL',
                'capital'             => '',
                'gsm_code'            => '299',
                'currency_fullname'   => 'Danish krone',
                'currency_short_name' => 'Øre',
                'currency_symbol'     => 'DKK',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 87,
                'name'                       => 'Grenada',
                'code'                       => 'GD',
                'capital'                    => '',
                'gsm_code'                   => '-472',
                'currency_fullname'          => 'Eastern Caribbean dollar',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'XCD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 88,
                'name'                => 'Guadeloupe',
                'code'                => 'GP',
                'capital'             => '',
                'gsm_code'            => '590',
                'currency_fullname'   => 'Euro',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'EUR',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 89,
                'name'                => 'Guam',
                'code'                => 'GU',
                'capital'             => '',
                'gsm_code'            => '-670',
                'currency_fullname'   => 'US Dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'USD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 90,
                'name'                       => 'Guatemala',
                'code'                       => 'GT',
                'capital'                    => '',
                'gsm_code'                   => '502',
                'currency_fullname'          => 'Guatemalan Quetzal',
                'currency_short_name'        => '',
                'currency_symbol'            => 'QTQ',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 91,
                'name'                => 'Guernsey and Alderney',
                'code'                => 'XU',
                'capital'             => null,
                'gsm_code'            => null,
                'currency_fullname'   => null,
                'currency_short_name' => null,
                'currency_symbol'     => null,
                'priority'            => 1,
                'sale_tax_type'       => null,
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 92,
                'name'                       => 'Guinea',
                'code'                       => 'GN',
                'capital'                    => '',
                'gsm_code'                   => '224',
                'currency_fullname'          => 'Guinea Franc',
                'currency_short_name'        => '',
                'currency_symbol'            => 'GNF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 93,
                'name'                => 'Guinea-Bissau',
                'code'                => 'GW',
                'capital'             => '',
                'gsm_code'            => '245',
                'currency_fullname'   => 'Guinea-Bissau Peso',
                'currency_short_name' => '',
                'currency_symbol'     => 'GWP',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 94,
                'name'                       => 'Guyana',
                'code'                       => 'GY',
                'capital'                    => '',
                'gsm_code'                   => '592',
                'currency_fullname'          => 'Guyana Dollar',
                'currency_short_name'        => '',
                'currency_symbol'            => 'GYD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 95,
                'name'                       => 'Haiti',
                'code'                       => 'HT',
                'capital'                    => '',
                'gsm_code'                   => '509',
                'currency_fullname'          => 'Haitian Gourde',
                'currency_short_name'        => '',
                'currency_symbol'            => 'HTG',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '10',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '09',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 96,
                'name'                => 'Heard and McDonald Islands',
                'code'                => 'HM',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => 'Australian dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'AUD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 97,
                'name'                       => 'Honduras',
                'code'                       => 'HN',
                'capital'                    => '',
                'gsm_code'                   => '504',
                'currency_fullname'          => 'Honduran Lempira',
                'currency_short_name'        => '',
                'currency_symbol'            => 'HNL',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 98,
                'name'                => 'Hong Kong S.A.R.',
                'code'                => 'HK',
                'capital'             => '',
                'gsm_code'            => '852',
                'currency_fullname'   => 'Hong Kong dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'HKD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 99,
                'name'                       => 'Hungary',
                'code'                       => 'HU',
                'capital'                    => '',
                'gsm_code'                   => '36',
                'currency_fullname'          => 'Hungarian Forint',
                'currency_short_name'        => '',
                'currency_symbol'            => 'HUF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 100,
                'name'                       => 'Iceland',
                'code'                       => 'IS',
                'capital'                    => '',
                'gsm_code'                   => '354',
                'currency_fullname'          => 'Iceland Krona',
                'currency_short_name'        => '',
                'currency_symbol'            => 'ISK',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 101,
                'name'                      => 'India',
                'code'                      => 'IN',
                'capital'                   => '',
                'gsm_code'                  => '+91',
                'currency_fullname'         => 'Indian rupee',
                'currency_short_name'       => 'Paisa',
                'currency_symbol'           => 'INR',
                'priority'                  => 0,
                'sale_tax_type'             => 'GST',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 102,
                'name'                       => 'Indonesia',
                'code'                       => 'ID',
                'capital'                    => '',
                'gsm_code'                   => '62',
                'currency_fullname'          => 'Indonesian Rupiah',
                'currency_short_name'        => '',
                'currency_symbol'            => 'IDR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 103,
                'name'                       => 'Iran',
                'code'                       => 'IR',
                'capital'                    => '',
                'gsm_code'                   => '98',
                'currency_fullname'          => 'Iranian rial',
                'currency_short_name'        => 'Dinar',
                'currency_symbol'            => 'IRR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '21',
                'financial_year_start_month' => '03',
                'financial_year_end_date'    => '20',
                'financial_year_end_month'   => '03',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 104,
                'name'                       => 'Iraq',
                'code'                       => 'IQ',
                'capital'                    => '',
                'gsm_code'                   => '964',
                'currency_fullname'          => 'Iraqi dinar',
                'currency_short_name'        => 'Fils',
                'currency_symbol'            => 'IQD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 105,
                'name'                       => 'Ireland',
                'code'                       => 'IE',
                'capital'                    => '',
                'gsm_code'                   => '353',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 106,
                'name'                       => 'Israel',
                'code'                       => 'IL',
                'capital'                    => '',
                'gsm_code'                   => '972',
                'currency_fullname'          => 'Israeli new shekel',
                'currency_short_name'        => 'Agora',
                'currency_symbol'            => 'ILS',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 107,
                'name'                       => 'Italy',
                'code'                       => 'IT',
                'capital'                    => '',
                'gsm_code'                   => '39',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 108,
                'name'                      => 'Jamaica',
                'code'                      => 'JM',
                'capital'                   => '',
                'gsm_code'                  => '-875',
                'currency_fullname'         => 'Jamaican dollar',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'JMD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 109,
                'name'                      => 'Japan',
                'code'                      => 'JP',
                'capital'                   => '',
                'gsm_code'                  => '81',
                'currency_fullname'         => 'Japanese yen',
                'currency_short_name'       => 'Sen',
                'currency_symbol'           => 'JPY',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 110,
                'name'                => 'Jersey',
                'code'                => 'XJ',
                'capital'             => '',
                'gsm_code'            => null,
                'currency_fullname'   => null,
                'currency_short_name' => null,
                'currency_symbol'     => null,
                'priority'            => 1,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 111,
                'name'                       => 'Jordan',
                'code'                       => 'JO',
                'capital'                    => '',
                'gsm_code'                   => '962',
                'currency_fullname'          => 'Jordanian dinar',
                'currency_short_name'        => 'Piastre',
                'currency_symbol'            => 'JOD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 112,
                'name'                       => 'Kazakhstan',
                'code'                       => 'KZ',
                'capital'                    => '',
                'gsm_code'                   => '7',
                'currency_fullname'          => 'Kazakhstan Tenge',
                'currency_short_name'        => '',
                'currency_symbol'            => 'KZT',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 113,
                'name'                      => 'Kenya',
                'code'                      => 'KE',
                'capital'                   => '',
                'gsm_code'                  => '254',
                'currency_fullname'         => 'Kenyan shilling',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'KES',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                   => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 114,
                'name'                => 'Kiribati',
                'code'                => 'KI',
                'capital'             => '',
                'gsm_code'            => '686',
                'currency_fullname'   => 'Australian dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'AUD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 115,
                'name'                       => 'Korea North',
                'code'                       => 'KP',
                'capital'                    => '',
                'gsm_code'                   => '850',
                'currency_fullname'          => 'North Korean won',
                'currency_short_name'        => 'Chon',
                'currency_symbol'            => 'KPW',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'formats'                    => 'm-d-Y',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 116,
                'name'                       => 'Korea South',
                'code'                       => 'KR',
                'capital'                    => '',
                'gsm_code'                   => '82',
                'currency_fullname'          => 'South Korean won',
                'currency_short_name'        => 'Jeon',
                'currency_symbol'            => 'KRW',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 117,
                'name'                      => 'Kuwait',
                'code'                      => 'KW',
                'capital'                   => '',
                'gsm_code'                  => '965',
                'currency_fullname'         => 'Kuwaiti dinar',
                'currency_short_name'       => 'Fils',
                'currency_symbol'           => 'KWD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 118,
                'name'                       => 'Kyrgyzstan',
                'code'                       => 'KG',
                'capital'                    => '',
                'gsm_code'                   => '996',
                'currency_fullname'          => 'Som',
                'currency_short_name'        => '',
                'currency_symbol'            => 'KGS',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 119,
                'name'                => 'Laos',
                'code'                => 'LA',
                'capital'             => '',
                'gsm_code'            => '856',
                'currency_fullname'   => 'Lao Kip',
                'currency_short_name' => '',
                'currency_symbol'     => 'LAK',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 120,
                'name'                => 'Latvia',
                'code'                => 'LV',
                'capital'             => '',
                'gsm_code'            => '371',
                'currency_fullname'   => 'Latvian Lats',
                'currency_short_name' => '',
                'currency_symbol'     => 'LVL',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 121,
                'name'                => 'Lebanon',
                'code'                => 'LB',
                'capital'             => '',
                'gsm_code'            => '961',
                'currency_fullname'   => 'Lebanese Pound',
                'currency_short_name' => '',
                'currency_symbol'     => 'LBP',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 122,
                'name'                      => 'Lesotho',
                'code'                      => 'LS',
                'capital'                   => '',
                'gsm_code'                  => '266',
                'currency_fullname'         => 'Lesotho Loti',
                'currency_short_name'       => '',
                'currency_symbol'           => 'LSL',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 123,
                'name'                => 'Liberia',
                'code'                => 'LR',
                'capital'             => '',
                'gsm_code'            => '231',
                'currency_fullname'   => 'Liberian Dollar',
                'currency_short_name' => '',
                'currency_symbol'     => 'LRD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 124,
                'name'                => 'Libya',
                'code'                => 'LY',
                'capital'             => '',
                'gsm_code'            => '218',
                'currency_fullname'   => 'Libyan dinar',
                'currency_short_name' => 'Dirham',
                'currency_symbol'     => 'LYD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 125,
                'name'                => 'Liechtenstein',
                'code'                => 'LI',
                'capital'             => '',
                'gsm_code'            => '423',
                'currency_fullname'   => 'Swiss franc',
                'currency_short_name' => 'Rappen',
                'currency_symbol'     => 'CHF',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 126,
                'name'                       => 'Lithuania',
                'code'                       => 'LT',
                'capital'                    => '',
                'gsm_code'                   => '370',
                'currency_fullname'          => 'Lithuanian Litas',
                'currency_short_name'        => '',
                'currency_symbol'            => 'LTL',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [

                'id'                         => 127,
                'name'                       => 'Luxembourg',
                'code'                       => 'LU',
                'capital'                    => '',
                'gsm_code'                   => '352',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 128,
                'name'                => 'Macau S.A.R.',
                'code'                => 'MO',
                'capital'             => '',
                'gsm_code'            => '853',
                'currency_fullname'   => 'Macau Pataca',
                'currency_short_name' => '',
                'currency_symbol'     => 'MOP',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 129,
                'name'                => 'Macedonia',
                'code'                => 'MK',
                'capital'             => '',
                'gsm_code'            => '389',
                'currency_fullname'   => '',
                'currency_short_name' => '',
                'currency_symbol'     => '',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],

            [

                'id'                         => 130,
                'name'                       => 'Madagascar',
                'code'                       => 'MG',
                'capital'                    => '',
                'gsm_code'                   => '261',
                'currency_fullname'          => 'Malagasy Franc',
                'currency_short_name'        => '',
                'currency_symbol'            => 'MGF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 131,
                'name'                       => 'Malawi',
                'code'                       => 'MW',
                'capital'                    => '',
                'gsm_code'                   => '265',
                'currency_fullname'          => 'Malawi Kwacha',
                'currency_short_name'        => '',
                'currency_symbol'            => 'MWK',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 132,
                'name'                       => 'Malaysia',
                'code'                       => 'MY',
                'capital'                    => '',
                'gsm_code'                   => '60',
                'currency_fullname'          => 'Malaysian Ringgit',
                'currency_short_name'        => '',
                'currency_symbol'            => 'MYR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 133,
                'name'                       => 'Maldives',
                'code'                       => 'MV',
                'capital'                    => '',
                'gsm_code'                   => '960',
                'currency_fullname'          => 'Maldive Rufiyaa',
                'currency_short_name'        => '',
                'currency_symbol'            => 'MVR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 134,
                'name'                       => 'Mali',
                'code'                       => 'ML',
                'capital'                    => '',
                'gsm_code'                   => '223',
                'currency_fullname'          => 'West African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XOF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 135,
                'name'                       => 'Malta',
                'code'                       => 'MT',
                'capital'                    => '',
                'gsm_code'                   => '356',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 136,
                'name'                => 'Man (Isle of)',
                'code'                => 'XM',
                'capital'             => '',
                'gsm_code'            => null,
                'currency_fullname'   => null,
                'currency_short_name' => null,
                'currency_symbol'     => null,
                'priority'            => 1,
                'sale_tax_type'       => null,
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 137,
                'name'                       => 'Marshall Islands',
                'code'                       => 'MH',
                'capital'                    => '',
                'gsm_code'                   => '692',
                'currency_fullname'          => 'US Dollar',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'USD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '10',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '09',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 138,
                'name'                => 'Martinique',
                'code'                => 'MQ',
                'capital'             => '',
                'gsm_code'            => '596',
                'currency_fullname'   => 'Euro',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'EUR',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 139,
                'name'                       => 'Mauritania',
                'code'                       => 'MR',
                'capital'                    => '',
                'gsm_code'                   => '222',
                'currency_fullname'          => 'Mauritanian Ouguiya',
                'currency_short_name'        => '',
                'currency_symbol'            => 'MRO',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 140,
                'name'                       => 'Mauritius',
                'code'                       => 'MU',
                'capital'                    => '',
                'gsm_code'                   => '230',
                'currency_fullname'          => 'Rupee',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'MUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 141,
                'name'                => 'Mayotte',
                'code'                => 'YT',
                'capital'             => '',
                'gsm_code'            => '269',
                'currency_fullname'   => 'Euro',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'EUR',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 142,
                'name'                       => 'Mexico',
                'code'                       => 'MX',
                'capital'                    => '',
                'gsm_code'                   => '52',
                'currency_fullname'          => 'Mexican peso',
                'currency_short_name'        => 'Centavo',
                'currency_symbol'            => 'MXN',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 143,
                'name'                       => 'Micronesia',
                'code'                       => 'FM',
                'capital'                    => '',
                'gsm_code'                   => '691',
                'currency_fullname'          => 'US Dollar',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'USD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '10',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '09',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 144,
                'name'                       => 'Moldova',
                'code'                       => 'MD',
                'capital'                    => '',
                'gsm_code'                   => '373',
                'currency_fullname'          => 'Moldovan Leu',
                'currency_short_name'        => '',
                'currency_symbol'            => 'MDL',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 145,
                'name'                       => 'Monaco',
                'code'                       => 'MC',
                'capital'                    => '',
                'gsm_code'                   => '377',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 146,
                'name'                       => 'Mongolia',
                'code'                       => 'MN',
                'capital'                    => '',
                'gsm_code'                   => '976',
                'currency_fullname'          => 'Mongolian Tugrik',
                'currency_short_name'        => '',
                'currency_symbol'            => 'MNT',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 147,
                'name'                => 'Montserrat',
                'code'                => 'MS',
                'capital'             => '',
                'gsm_code'            => '-663',
                'currency_fullname'   => 'Eastern Caribbean dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'XCD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 148,
                'name'                       => 'Morocco',
                'code'                       => 'MA',
                'capital'                    => '',
                'gsm_code'                   => '212',
                'currency_fullname'          => 'Moroccan dirham',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'MAD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 149,
                'name'                       => 'Mozambique',
                'code'                       => 'MZ',
                'capital'                    => '',
                'gsm_code'                   => '258',
                'currency_fullname'          => 'Mozambique Metical',
                'currency_short_name'        => '',
                'currency_symbol'            => 'MZN',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 150,
                'name'                       => 'Myanmar',
                'code'                       => 'm',
                'capital'                    => '',
                'gsm_code'                   => '95',
                'currency_fullname'          => 'Myanmar Kyat',
                'currency_short_name'        => '',
                'currency_symbol'            => 'mK',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '10',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '09',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 151,
                'name'                      => 'Namibia',
                'code'                      => 'NA',
                'capital'                   => '',
                'gsm_code'                  => '264',
                'currency_fullname'         => 'Namibian Dollar',
                'currency_short_name'       => '',
                'currency_symbol'           => 'NAD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 152,
                'name'                       => 'Nauru',
                'code'                       => 'NR',
                'capital'                    => '',
                'gsm_code'                   => '674',
                'currency_fullname'          => 'Australian dollar',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'AUD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 153,
                'name'                       => 'Nepal',
                'code'                       => 'NP',
                'capital'                    => '',
                'gsm_code'                   => '+977',
                'currency_fullname'          => 'Nepalese Rupee',
                'currency_short_name'        => '',
                'currency_symbol'            => 'NPR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '16',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '15',
                'financial_year_end_month'   => '07',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 154,
                'name'                => 'Netherlands Antilles',
                'code'                => 'AN',
                'capital'             => '',
                'gsm_code'            => '599',
                'currency_fullname'   => '',
                'currency_short_name' => '',
                'currency_symbol'     => '',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 155,
                'name'                => 'Netherlands The',
                'code'                => 'NL',
                'capital'             => '',
                'gsm_code'            => '31',
                'currency_fullname'   => 'Euro',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'EUR',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 156,
                'name'                => 'New Caledonia',
                'code'                => 'NC',
                'capital'             => '',
                'gsm_code'            => '687',
                'currency_fullname'   => 'CFP franc',
                'currency_short_name' => 'Centime',
                'currency_symbol'     => 'XPF',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 157,
                'name'                      => 'New Zealand',
                'code'                      => 'NZ',
                'capital'                   => '',
                'gsm_code'                  => '64',
                'currency_fullname'         => 'New Zealand dollar',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'NZD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 158,
                'name'                       => 'Nicaragua',
                'code'                       => 'NI',
                'capital'                    => '',
                'gsm_code'                   => '505',
                'currency_fullname'          => 'Nicaraguan Cordoba Oro',
                'currency_short_name'        => '',
                'currency_symbol'            => 'NIO',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 159,
                'name'                       => 'Niger',
                'code'                       => 'NE',
                'capital'                    => '',
                'gsm_code'                   => '227',
                'currency_fullname'          => 'West African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XOF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'formats'                    => 'm-d-Y',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 160,
                'name'                => 'Nigeria',
                'code'                => 'NG',
                'capital'             => '',
                'gsm_code'            => '234',
                'currency_fullname'   => 'Naira',
                'currency_short_name' => 'Kobo',
                'currency_symbol'     => 'NGN',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 161,
                'name'                => 'Niue',
                'code'                => 'NU',
                'capital'             => '',
                'gsm_code'            => '683',
                'currency_fullname'   => 'New Zealand dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'NZD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 162,
                'name'                => 'Norfolk Island',
                'code'                => 'NF',
                'capital'             => '',
                'gsm_code'            => '672',
                'currency_fullname'   => 'Australian dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'AUD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 163,
                'name'                => 'Northern Mariana Islands',
                'code'                => 'MP',
                'capital'             => '',
                'gsm_code'            => '-669',
                'currency_fullname'   => 'US Dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'USD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 164,
                'name'                       => 'Norway',
                'code'                       => 'NO',
                'capital'                    => '',
                'gsm_code'                   => '47',
                'currency_fullname'          => 'Norwegian Krone',
                'currency_short_name'        => '',
                'currency_symbol'            => 'NOK',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 165,
                'name'                       => 'Oman',
                'code'                       => 'OM',
                'capital'                    => '',
                'gsm_code'                   => '968',
                'currency_fullname'          => 'Omani Rial',
                'currency_short_name'        => '',
                'currency_symbol'            => 'OMR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 166,
                'name'                       => 'Pakistan',
                'code'                       => 'PK',
                'capital'                    => '',
                'gsm_code'                   => '92',
                'currency_fullname'          => 'Pakistan Rupee',
                'currency_short_name'        => '',
                'currency_symbol'            => 'PKR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 167,
                'name'                       => 'Palau',
                'code'                       => 'PW',
                'capital'                    => '',
                'gsm_code'                   => '680',
                'currency_fullname'          => 'US Dollar',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'USD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '10',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '09',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 168,
                'name'                => 'Palestinian Territory Occupied',
                'code'                => 'PS',
                'capital'             => '',
                'gsm_code'            => '970',
                'currency_fullname'   => '',
                'currency_short_name' => '',
                'currency_symbol'     => '',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 169,
                'name'                       => 'Panama',
                'code'                       => 'PA',
                'capital'                    => '',
                'gsm_code'                   => '507',
                'currency_fullname'          => 'Panamanian Balboa',
                'currency_short_name'        => '',
                'currency_symbol'            => 'PAB',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 170,
                'name'                       => 'Papua New Guinea',
                'code'                       => 'PG',
                'capital'                    => '',
                'gsm_code'                   => '675',
                'currency_fullname'          => 'Papua New Guinea Kina',
                'currency_short_name'        => '',
                'currency_symbol'            => 'PGK',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 171,
                'name'                       => 'Paraguay',
                'code'                       => 'PY',
                'capital'                    => '',
                'gsm_code'                   => '595',
                'currency_fullname'          => 'Paraguayan guaraní',
                'currency_short_name'        => 'Céntimo',
                'currency_symbol'            => 'PYG',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 172,
                'name'                       => 'Peru',
                'code'                       => 'PE',
                'capital'                    => '',
                'gsm_code'                   => '51',
                'currency_fullname'          => 'Peruvian sol',
                'currency_short_name'        => 'Céntimo',
                'currency_symbol'            => 'PEN',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 173,
                'name'                       => 'Philippines',
                'code'                       => 'PH',
                'capital'                    => '',
                'gsm_code'                   => '63',
                'currency_fullname'          => 'Philippine peso',
                'currency_short_name'        => 'Sentimo',
                'currency_symbol'            => 'PHP',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 174,
                'name'                => 'Pitcairn Island',
                'code'                => 'PN',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => 'New Zealand dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'NZD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 175,
                'name'                       => 'Poland',
                'code'                       => 'PL',
                'capital'                    => '',
                'gsm_code'                   => '48',
                'currency_fullname'          => 'Polish Zloty',
                'currency_short_name'        => '',
                'currency_symbol'            => 'PLN',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 176,
                'name'                       => 'Portugal',
                'code'                       => 'PT',
                'capital'                    => '',
                'gsm_code'                   => '351',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 177,
                'name'                => 'Puerto Rico',
                'code'                => 'PR',
                'capital'             => '',
                'gsm_code'            => '+1-787 or +1-939',
                'currency_fullname'   => 'US Dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'USD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 178,
                'name'                      => 'Qatar',
                'code'                      => 'QA',
                'capital'                   => '',
                'gsm_code'                  => '974',
                'currency_fullname'         => 'Qatari riyal',
                'currency_short_name'       => 'Dirham',
                'currency_symbol'           => 'QAR',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 179,
                'name'                => 'Reunion',
                'code'                => 'RE',
                'capital'             => '',
                'gsm_code'            => '262',
                'currency_fullname'   => 'Euro',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'EUR',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 180,
                'name'                       => 'Romania',
                'code'                       => 'RO',
                'capital'                    => '',
                'gsm_code'                   => '40',
                'currency_fullname'          => 'Romanian leu',
                'currency_short_name'        => 'Ban',
                'currency_symbol'            => 'RON',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 181,
                'name'                       => 'Russia',
                'code'                       => 'RU',
                'capital'                    => '',
                'gsm_code'                   => '7',
                'currency_fullname'          => 'Russian ruble',
                'currency_short_name'        => 'Kopek',
                'currency_symbol'            => 'RUB',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 182,
                'name'                       => 'Rwanda',
                'code'                       => 'RW',
                'capital'                    => '',
                'gsm_code'                   => '250',
                'currency_fullname'          => 'Rwandan franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'RWF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 183,
                'name'                => 'Saint Helena',
                'code'                => 'SH',
                'capital'             => '',
                'gsm_code'            => '290',
                'currency_fullname'   => 'Saint Helena pound',
                'currency_short_name' => 'Penny',
                'currency_symbol'     => 'SHP',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 184,
                'name'                       => 'Saint Kitts And Nevis',
                'code'                       => 'KN',
                'capital'                    => '',
                'gsm_code'                   => '-868',
                'currency_fullname'          => 'Eastern Caribbean dollar',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'XCD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 185,
                'name'                      => 'Saint Lucia',
                'code'                      => 'LC',
                'capital'                   => '',
                'gsm_code'                  => '-757',
                'currency_fullname'         => 'Eastern Caribbean dollar',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'XCD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 186,
                'name'                => 'Saint Pierre and Miquelon',
                'code'                => 'PM',
                'capital'             => '',
                'gsm_code'            => '508',
                'currency_fullname'   => 'Euro',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'EUR',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 187,
                'name'                       => 'Saint Vincent And The Grenadines',
                'code'                       => 'VC',
                'capital'                    => '',
                'gsm_code'                   => '-783',
                'currency_fullname'          => 'Eastern Caribbean dollar',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'XCD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 188,
                'name'                => 'Samoa',
                'code'                => 'WS',
                'capital'             => '',
                'gsm_code'            => '685',
                'currency_fullname'   => 'Samoan Tala',
                'currency_short_name' => '',
                'currency_symbol'     => 'WST',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '06',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '05',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 189,
                'name'                       => 'San Marino',
                'code'                       => 'SM',
                'capital'                    => '',
                'gsm_code'                   => '378',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 190,
                'name'                       => 'Sao Tome and Principe',
                'code'                       => 'ST',
                'capital'                    => '',
                'gsm_code'                   => '239',
                'currency_fullname'          => 'Dobra',
                'currency_short_name'        => '',
                'currency_symbol'            => 'STD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 191,
                'name'                       => 'Saudi Arabia',
                'code'                       => 'SA',
                'capital'                    => '',
                'gsm_code'                   => '966',
                'currency_fullname'          => 'Saudi riyal',
                'currency_short_name'        => 'Halala',
                'currency_symbol'            => 'SAR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 192,
                'name'                       => 'Senegal',
                'code'                       => 'SN',
                'capital'                    => '',
                'gsm_code'                   => '221',
                'currency_fullname'          => 'West African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XOF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 193,
                'name'                       => 'Serbia',
                'code'                       => 'RS',
                'capital'                    => '',
                'gsm_code'                   => '',
                'currency_fullname'          => 'Serbian dinar',
                'currency_short_name'        => 'Para',
                'currency_symbol'            => 'RSD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 194,
                'name'                       => 'Seychelles',
                'code'                       => 'SC',
                'capital'                    => '',
                'gsm_code'                   => '248',
                'currency_fullname'          => 'Seychelles Rupee',
                'currency_short_name'        => '',
                'currency_symbol'            => 'SCR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'             => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 195,
                'name'                       => 'Sierra Leone',
                'code'                       => 'SL',
                'capital'                    => '',
                'gsm_code'                   => '232',
                'currency_fullname'          => 'Sierra Leone Leone',
                'currency_short_name'        => '',
                'currency_symbol'            => 'SLL',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 196,
                'name'                      => 'Singapore',
                'code'                      => 'SG',
                'capital'                   => '',
                'gsm_code'                  => '65',
                'currency_fullname'         => 'Singapore dollar',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'SGD',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 197,
                'name'                       => 'Slovakia',
                'code'                       => 'SK',
                'capital'                    => '',
                'gsm_code'                   => '421',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 198,
                'name'                       => 'Slovenia',
                'code'                       => 'SI',
                'capital'                    => '',
                'gsm_code'                   => '386',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 199,
                'name'                => 'Smaller Territories of the UK',
                'code'                => 'XG',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => '',
                'currency_short_name' => '',
                'currency_symbol'     => '',
                'priority'            => 1,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 200,
                'name'                       => 'Solomon Islands',
                'code'                       => 'SB',
                'capital'                    => '',
                'gsm_code'                   => '677',
                'currency_fullname'          => 'Solomon Islands Dollar',
                'currency_short_name'        => '',
                'currency_symbol'            => 'SBD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 201,
                'name'                => 'Somalia',
                'code'                => 'SO',
                'capital'             => '',
                'gsm_code'            => '252',
                'currency_fullname'   => 'Somali Shilling',
                'currency_short_name' => '',
                'currency_symbol'     => 'SOS',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                        => 202,
                'name'                      => 'South Africa',
                'code'                      => 'ZA',
                'capital'                   => '',
                'gsm_code'                  => '27',
                'currency_fullname'         => 'South African rand',
                'currency_short_name'       => 'Cent',
                'currency_symbol'           => 'ZAR',
                'priority'                  => 0,
                'sale_tax_type'             => '',
                'status'                    => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '03',
                'created_at'                => date('Y-m-d H:i:s'),
                'updated_at'                => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 203,
                'name'                => 'South Georgia',
                'code'                => 'GS',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => 'Pound',
                'currency_short_name' => 'Penny',
                'currency_symbol'     => 'GBP',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 204,
                'name'                       => 'South Sudan',
                'code'                       => 'SS',
                'capital'                    => null,
                'gsm_code'                   => null,
                'currency_fullname'          => null,
                'currency_short_name'        => null,
                'currency_symbol'            => null,
                'priority'                   => 1,
                'sale_tax_type'              => null,
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 205,
                'name'                       => 'Spain',
                'code'                       => 'ES',
                'capital'                    => '',
                'gsm_code'                   => '34',
                'currency_fullname'          => 'Euro',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'EUR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 206,
                'name'                       => 'Sri Lanka',
                'code'                       => 'LK',
                'capital'                    => '',
                'gsm_code'                   => '94',
                'currency_fullname'          => 'Sri Lanka Rupee',
                'currency_short_name'        => '',
                'currency_symbol'            => 'LKR',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 207,
                'name'                       => 'Sudan',
                'code'                       => 'SD',
                'capital'                    => '',
                'gsm_code'                   => '249',
                'currency_fullname'          => 'Sudanese pound',
                'currency_short_name'        => 'Piastre',
                'currency_symbol'            => 'SDG',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 208,
                'name'                       => 'Suriname',
                'code'                       => 'SR',
                'capital'                    => '',
                'gsm_code'                   => '597',
                'currency_fullname'          => 'Surinam Dollar',
                'currency_short_name'        => '',
                'currency_symbol'            => 'SRD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 209,
                'name'                => 'Svalbard And Jan Mayen Islands',
                'code'                => 'SJ',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => 'Norwegian Krone',
                'currency_short_name' => '',
                'currency_symbol'     => 'NOK',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 210,
                'name'                => 'Swaziland',
                'code'                => 'SZ',
                'capital'             => '',
                'gsm_code'            => '268',
                'currency_fullname'   => 'Swiss franc',
                'currency_short_name' => 'Rappen',
                'currency_symbol'     => 'CHF',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 211,
                'name'                       => 'Sweden',
                'code'                       => 'SE',
                'capital'                    => '',
                'gsm_code'                   => '46',
                'currency_fullname'          => 'Swedish krona',
                'currency_short_name'        => 'Öre',
                'currency_symbol'            => 'SEK',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 212,
                'name'                       => 'Switzerland',
                'code'                       => 'CH',
                'capital'                    => '',
                'gsm_code'                   => '41',
                'currency_fullname'          => 'Swiss franc',
                'currency_short_name'        => 'Rappen',
                'currency_symbol'            => 'CHF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 213,
                'name'                       => 'Syria',
                'code'                       => 'SY',
                'capital'                    => '',
                'gsm_code'                   => '963',
                'currency_fullname'          => 'Syrian pound',
                'currency_short_name'        => 'Piastre',
                'currency_symbol'            => 'SYP',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 214,
                'name'                => 'Taiwan',
                'code'                => 'TW',
                'capital'             => '',
                'gsm_code'            => '886',
                'currency_fullname'   => 'New Taiwan dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'TWD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 215,
                'name'                       => 'Tajikistan',
                'code'                       => 'TJ',
                'capital'                    => '',
                'gsm_code'                   => '992',
                'currency_fullname'          => 'Tajik Somoni',
                'currency_short_name'        => '',
                'currency_symbol'            => 'TJS',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 216,
                'name'                       => 'Tanzania',
                'code'                       => 'TZ',
                'capital'                    => '',
                'gsm_code'                   => '255',
                'currency_fullname'          => 'Tanzanian Shilling',
                'currency_short_name'        => '',
                'currency_symbol'            => 'TZS',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 217,
                'name'                       => 'Thailand',
                'code'                       => 'TH',
                'capital'                    => '',
                'gsm_code'                   => '66',
                'currency_fullname'          => 'Thai baht',
                'currency_short_name'        => 'Satang',
                'currency_symbol'            => 'THB',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '10',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '09',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 218,
                'name'                       => 'Togo',
                'code'                       => 'TG',
                'capital'                    => '',
                'gsm_code'                   => '',
                'currency_fullname'          => 'West African CFA franc',
                'currency_short_name'        => 'Centime',
                'currency_symbol'            => 'XOF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 219,
                'name'                => 'Tokelau',
                'code'                => 'TK',
                'capital'             => '',
                'gsm_code'            => '690',
                'currency_fullname'   => 'New Zealand dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'NZD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 220,
                'name'                       => 'Tonga',
                'code'                       => 'TO',
                'capital'                    => '',
                'gsm_code'                   => '676',
                'currency_fullname'          => 'Tongan Pa\'anga',
                'currency_short_name'        => '',
                'currency_symbol'            => 'TOP',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'formats'                    => 'm-d-Y',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 221,
                'name'                       => 'Trinidad And Tobago',
                'code'                       => 'TT',
                'capital'                    => '',
                'gsm_code'                   => '-867',
                'currency_fullname'          => 'Trinidad and Tobago Dollar',
                'currency_short_name'        => '',
                'currency_symbol'            => 'TTD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '10',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '09',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 222,
                'name'                       => 'Tunisia',
                'code'                       => 'TN',
                'capital'                    => '',
                'gsm_code'                   => '216',
                'currency_fullname'          => 'Tunisian dinar',
                'currency_short_name'        => 'Millime',
                'currency_symbol'            => 'TND',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 223,
                'name'                       => 'Turkey',
                'code'                       => 'TR',
                'capital'                    => '',
                'gsm_code'                   => '90',
                'currency_fullname'          => 'Turkish lira',
                'currency_short_name'        => 'Kuruş',
                'currency_symbol'            => 'TRY',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 224,
                'name'                       => 'Turkmenistan',
                'code'                       => 'TM',
                'capital'                    => '',
                'gsm_code'                   => '993',
                'currency_fullname'          => 'Manat',
                'currency_short_name'        => '',
                'currency_symbol'            => 'TMT',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 225,
                'name'                => 'Turks And Caicos Islands',
                'code'                => 'TC',
                'capital'             => '',
                'gsm_code'            => '-648',
                'currency_fullname'   => 'US Dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'USD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 226,
                'name'                       => 'Tuvalu',
                'code'                       => 'TV',
                'capital'                    => '',
                'gsm_code'                   => '688',
                'currency_fullname'          => 'Australian dollar',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'AUD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 227,
                'name'                       => 'Uganda',
                'code'                       => 'UG',
                'capital'                    => '',
                'gsm_code'                   => '256',
                'currency_fullname'          => 'Ugandan shilling',
                'currency_short_name'        => 'Cent',
                'currency_symbol'            => 'UGX',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '07',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '06',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 228,
                'name'                       => 'Ukraine',
                'code'                       => 'UA',
                'capital'                    => '',
                'gsm_code'                   => '380',
                'currency_fullname'          => 'Ukraine Hryvnia',
                'currency_short_name'        => '',
                'currency_symbol'            => 'UAH',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 229,
                'name'                       => 'United Arab Emirates',
                'code'                       => 'AE',
                'capital'                    => '',
                'gsm_code'                   => '971',
                'currency_fullname'          => 'United Arab Emirates dirham',
                'currency_short_name'        => 'Fils',
                'currency_symbol'            => 'AED',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 230,
                'name'                       => 'United Kingdom',
                'code'                       => 'GB',
                'capital'                    => '',
                'gsm_code'                   => '',
                'currency_fullname'          => '',
                'currency_short_name'        => '',
                'currency_symbol'            => '',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '06',
                'financial_year_start_month' => '04',
                'financial_year_end_date'    => '05',
                'financial_year_end_month'   => '04',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 231,
                'name'                       => 'United States',
                'code'                       => 'US',
                'capital'                    => '',
                'gsm_code'                   => '1',
                'currency_fullname'          => '',
                'currency_short_name'        => '',
                'currency_symbol'            => '',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '10',
                'financial_year_end_date'    => '30',
                'financial_year_end_month'   => '09',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 232,
                'name'                => 'United States Minor Outlying Islands',
                'code'                => 'UM',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => '',
                'currency_short_name' => '',
                'currency_symbol'     => '',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 233,
                'name'                       => 'Uruguay',
                'code'                       => 'UY',
                'capital'                    => '',
                'gsm_code'                   => '598',
                'currency_fullname'          => 'Uruguayan Peso',
                'currency_short_name'        => '',
                'currency_symbol'            => 'UYU',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 234,
                'name'                       => 'Uzbekistan',
                'code'                       => 'UZ',
                'capital'                    => '',
                'gsm_code'                   => '998',
                'currency_fullname'          => 'Uzbekistan Sum',
                'currency_short_name'        => '',
                'currency_symbol'            => 'UZS',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 235,
                'name'                       => 'Vanuatu',
                'code'                       => 'VU',
                'capital'                    => '',
                'gsm_code'                   => '678',
                'currency_fullname'          => 'Vanuatu Vatu',
                'currency_short_name'        => '',
                'currency_symbol'            => 'VUV',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 236,
                'name'                => 'Vatican City State (Holy See)',
                'code'                => 'VA',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => 'Euro',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'EUR',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 237,
                'name'                       => 'Venezuela',
                'code'                       => 'VE',
                'capital'                    => '',
                'gsm_code'                   => '58',
                'currency_fullname'          => 'Venezuelan Bolivar',
                'currency_short_name'        => '',
                'currency_symbol'            => 'VEF',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 238,
                'name'                       => 'Vietnam',
                'code'                       => 'VN',
                'capital'                    => '',
                'gsm_code'                   => '84',
                'currency_fullname'          => 'Vietnamese Dong',
                'currency_short_name'        => '',
                'currency_symbol'            => 'VND',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 239,
                'name'                => 'Virgin Islands (British)',
                'code'                => 'VG',
                'capital'             => null,
                'gsm_code'            => null,
                'currency_fullname'   => null,
                'currency_short_name' => null,
                'currency_symbol'     => null,
                'priority'            => 1,
                'sale_tax_type'       => null,
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 240,
                'name'                => 'Virgin Islands (US)',
                'code'                => 'VI',
                'capital'             => '',
                'gsm_code'            => '-283',
                'currency_fullname'   => 'US Dollar',
                'currency_short_name' => 'Cent',
                'currency_symbol'     => 'USD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 241,
                'name'                => 'Wallis And Futuna Islands',
                'code'                => 'WF',
                'capital'             => '',
                'gsm_code'            => '681',
                'currency_fullname'   => 'CFP franc',
                'currency_short_name' => 'Centime',
                'currency_symbol'     => 'XPF',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 242,
                'name'                => 'Western Sahara',
                'code'                => 'EH',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => 'Moroccan dirham',
                'currency_short_name' => 'Centime',
                'currency_symbol'     => 'MAD',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 243,
                'name'                => 'Yemen',
                'code'                => 'YE',
                'capital'             => '',
                'gsm_code'            => '967',
                'currency_fullname'   => 'Yemeni rial',
                'currency_short_name' => 'Fils',
                'currency_symbol'     => 'YER',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                  => 244,
                'name'                => 'Yugoslavia',
                'code'                => 'YU',
                'capital'             => '',
                'gsm_code'            => '',
                'currency_fullname'   => '',
                'currency_short_name' => '',
                'currency_symbol'     => '',
                'priority'            => 0,
                'sale_tax_type'       => '',
                'status'              => 1,
                'formats'             => 'm-d-Y',
                'created_at'          => date('Y-m-d H:i:s'),
                'updated_at'          => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 245,
                'name'                       => 'Zambia',
                'code'                       => 'ZM',
                'capital'                    => '',
                'gsm_code'                   => '260',
                'currency_fullname'          => 'Zambian Kwacha',
                'currency_short_name'        => '',
                'currency_symbol'            => 'ZMW',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ],
            [
                'id'                         => 246,
                'name'                       => 'Zimbabwe',
                'code'                       => 'ZW',
                'capital'                    => '',
                'gsm_code'                   => '263',
                'currency_fullname'          => 'Zimbabwe Dollar',
                'currency_short_name'        => '',
                'currency_symbol'            => 'ZWD',
                'priority'                   => 0,
                'sale_tax_type'              => '',
                'status'                     => 1,
                'formats'                    => 'm-d-Y',
                'financial_year_start_date'  => '01',
                'financial_year_start_month' => '01',
                'financial_year_end_date'    => '31',
                'financial_year_end_month'   => '12',
                'created_at'                 => date('Y-m-d H:i:s'),
                'updated_at'                 => date('Y-m-d H:i:s')
            ]
        ];

        // \DB::table('countries')->insert($countries);
        foreach ($countries as $data) {
            Country::firstOrCreate(
                [
                    'id' => $data['id']
                ],
                $data
            );
        }
    }
}
