<?php
  
namespace Database\Seeders;
  
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
  
class CreateAdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (User::whereEmail('admin@gmail.com')->exists()) {
            $user = User::whereEmail('admin@gmail.com')->first();
        } else { 
            $user = User::create([
                'name'       => 'Admin', 
                'email'      => 'admin@gmail.com',
                'company_id' => 1,
                'password'   => bcrypt('123456'),
                'user_type'  => 'admin'
            ]);
        }

        if (Role::whereName('Admin')->exists()) {
            $role = Role::whereName('Admin')->first();
            $permissions = Permission::pluck('id','id')->all();
        } else {
            $role = Role::create(['name' => 'Admin']);
            $permissions = Permission::pluck('id','id')->all();
       
            $role->syncPermissions($permissions);
            $user->assignRole([$role->id]);
        }

        if (Role::whereName('SuperAdmin')->exists()) {
            $role = Role::whereName('SuperAdmin')->first();
        } else {
            $role = Role::create(['name' => 'SuperAdmin']);
            $role->syncPermissions($permissions);
        }


        if (User::whereEmail('superadmin@gmail.com')->exists()) {
            $super_admin = User::whereEmail('superadmin@gmail.com')->first();
        } else {
            $super_admin = User::create([
                'name'           => 'Admin', 
                'email'          => 'superadmin@gmail.com',
                'company_id'     => 1,
                'password'       => bcrypt('123456'),
                'is_super_admin' => 1,
                'user_type'      => 'admin'
            ]);
            $super_admin->assignRole([$role->id]);
        }

    }
}