<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class CreateBillingUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (User::whereEmail('billinguser@gmail.com')->exists()) {
            $user = User::whereEmail('billinguser@gmail.com')->first();
        } else {
            $user = User::create([
                'name'       => 'Billing User', 
                'email'      => 'billinguser@gmail.com',
                'company_id' => 1,
                'password'   => bcrypt('123456')
            ]);
        }

        if (Role::whereName('Billing-User')->exists()) {
            $role = Role::whereName('Billing-User')->first();
        } else {
            $role = Role::create(['name' => 'Billing-User']);
        }

        $permissions = [
        	'pathology-lab-billing-list',
        	'pathology-lab-billing-create',
        ];

        $permissions = Permission::whereIn('name', $permissions)->pluck('id','id')->all();
        $role->syncPermissions($permissions);
        $user->assignRole([$role->id]);
    }
}
