<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class CreateDoctorUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (User::whereEmail('doctor@gmail.com')->exists()) {
            $user = User::whereEmail('doctor@gmail.com')->first();
        } else {
            $user = User::create([
                'name'       => 'doctor', 
                'email'      => 'doctor@gmail.com',
                'company_id' => 1,
                'password'   => bcrypt('123456')
            ]);
        }

        if (Role::whereName('Doctor')->exists()) {
            $role = Role::whereName('Doctor')->first();
        } else {
            $role = Role::create(['name' => 'Doctor']);
        }

        $permissions = [
        	'dashboard-list',
        	'doctor-reviews-list',
        ];

        $permissions = Permission::whereIn('name', $permissions)->pluck('id','id')->all();
        $role->syncPermissions($permissions);
        $user->assignRole([$role->id]);
    }
}
