<?php
  
namespace Database\Seeders;
  
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
  
class CreateFacultyUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (User::whereEmail('faculty@gmail.com')->exists()) {
            $user = User::whereEmail('faculty@gmail.com')->first();
        } else {
            $user = User::create([
                'name'       => 'Faculty', 
                'email'      => 'faculty@gmail.com',
                'company_id' => 1,
                'password'   => bcrypt('123456')
            ]);
        }

        if (Role::whereName('Faculty')->exists()) {
            $role = Role::whereName('Faculty')->first();
        } else {
            $role = Role::create(['name' => 'Faculty']);
        }
     
        $permissions = Permission::where('name', 'LIKE', '%courses%')->pluck('id','id')->all();
        $role->syncPermissions($permissions);
        $user->assignRole([$role->id]);
    }
}