<?php
  
namespace Database\Seeders;
  
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
  
class CreateLibrarianUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (User::whereEmail('librarian@gmail.com')->exists()) {
            $user = User::whereEmail('librarian@gmail.com')->first();
        } else {
            $user = User::create([
                'name'       => 'Librarian', 
                'email'      => 'librarian@gmail.com',
                'company_id' => 1,
                'password'   => bcrypt('123456')
            ]);
        }

        if (Role::whereName('Librarian')->exists()) {
            $role = Role::whereName('Librarian')->first();
        } else {
            $role = Role::create(['name' => 'Librarian']);
        }
     
        $permissions = Permission::where('name', 'LIKE', '%library%')
            ->orWhere('name', 'LIKE', '%book%')
            ->orWhere('name', 'LIKE', '%company%')
            ->orWhere('name', 'LIKE', '%students%')
            ->orWhere('name', 'LIKE', '%faculty%')
            ->orWhere('name', 'LIKE', '%account%')
            ->orWhere('module_id', 6)
            ->orWhere('module_id', 12)
            ->orWhere('module_id', 26)
            ->orWhere('module_id', 47)
            ->orWhere('module_id', 49)
            ->orWhere('module_id', 50)
            ->orWhere('module_id', 150)
            ->orWhere('module_id', 151)
            ->orWhere('module_id', 152)
            ->orWhere('module_id', 153)
            ->orWhere('module_id', 173)
            ->orWhere('module_id', 174)
            ->orWhere('module_id', 175)
            ->orWhere('module_id', 176)
            ->orWhere('module_id', 177)
            ->orWhere('module_id', 179)
            ->orWhere('module_id', 180)
            ->orWhere('module_id', 182)
            ->orWhere('module_id', 183)
            ->orWhere('module_id', 184)
            ->orWhere('module_id', 185)
            ->orWhere('module_id', 186)
            ->orWhere('module_id', 187)
            ->orWhere('module_id', 194)
            ->orWhere('module_id', 195)
            ->pluck('id','id')
            ->all();

        $role->syncPermissions($permissions);
        $user->assignRole([$role->id]);
    }
}