<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class CreateNurseUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (User::whereEmail('nurse@gmail.com')->exists()) {
            $user = User::whereEmail('nurse@gmail.com')->first();
        } else {
            $user = User::create([
                'name'       => 'nurse', 
                'email'      => 'nurse@gmail.com',
                'company_id' => 1,
                'password'   => bcrypt('123456')
            ]);
        }

        if (Role::whereName('Nurse')->exists()) {
            $role = Role::whereName('Nurse')->first();
        } else {
            $role = Role::create(['name' => 'Nurse']);
        }

        $permissions = [
        	'dashboard-list',
        	'doctor-reviews-list',
        	'sample-collections-list',
        	'result-update-list',
        ];

        $permissions = Permission::whereIn('name', $permissions)->pluck('id','id')->all();
        $role->syncPermissions($permissions);
        $user->assignRole([$role->id]);
    }
}
