<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class CreateTechnicianUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (User::whereEmail('technician@gmail.com')->exists()) {
            $user = User::whereEmail('technician@gmail.com')->first();
        } else {
            $user = User::create([
                'name'       => 'Technician', 
                'email'      => 'technician@gmail.com',
                'company_id' => 1,
                'password'   => bcrypt('123456')
            ]);
        }

        if (Role::whereName('Technician')->exists()) {
            $role = Role::whereName('Technician')->first();
        } else {
            $role = Role::create(['name' => 'Technician']);
        }

        $permissions = [
        	'dashboard-list',
        	'sample-collections-list',
        	'result-update-list',
        ];

        $permissions = Permission::whereIn('name', $permissions)->pluck('id','id')->all();
        $role->syncPermissions($permissions);
        $user->assignRole([$role->id]);
    }
}
