<?php
namespace Database\Seeders;

use App\Models\Currency;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CurrencyTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        /**
         * Reset the countries table
         */
        // if (\App::environment('local')) {
        //     \DB::table('currencies')->truncate();
        // }

            $currency = [
            [
                'currency_abbreviation' => 'AFN',
                'currency_name' => 'Afghani',
                'sort_order' => 1,
                'symbol' => '؋'
            ],
            [
                'currency_abbreviation' => 'ALL',
                'currency_name' => 'Lek',
                'sort_order' => 2,
                'symbol' => 'Lek'
            ],
            [
                'currency_abbreviation' => 'ANG',
                'currency_name' => 'Netherlands Antillian Guilder',
                'sort_order' => 3,
                'symbol' => 'ƒ'
            ],
            [
                'currency_abbreviation' => 'ARS',
                'currency_name' => 'Argentine Peso',
                'sort_order' => 4,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'AUD',
                'currency_name' => 'Australian Dollar',
                'sort_order' => 5,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'AWG',
                'currency_name' => 'Aruban Guilder',
                'sort_order' => 6,
                'symbol' => 'ƒ'
            ],
            [
                'currency_abbreviation' => 'AZN',
                'currency_name' => 'Azerbaijanian Manat',
                'sort_order' => 7,
                'symbol' => 'ман'
            ],
            [
                'currency_abbreviation' => 'BAM',
                'currency_name' => 'Convertible Marks',
                'sort_order' => 8,
                'symbol' => 'KM'
            ],
            [
                'currency_abbreviation' => 'BDT',
                'currency_name' => 'Bangladeshi Taka',
                'sort_order' => 9,
                'symbol' => '৳'],
            [
                'currency_abbreviation' => 'BBD',
                'currency_name' => 'Barbados Dollar',
                'sort_order' => 10,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'BGN',
                'currency_name' => 'Bulgarian Lev',
                'sort_order' => 11,
                'symbol' => 'лв'
            ],
            [
                'currency_abbreviation' => 'BMD',
                'currency_name' => 'Bermudian Dollar',
                'sort_order' => 12,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'BND',
                'currency_name' => 'Brunei Dollar',
                'sort_order' => 13,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'BOB',
                'currency_name' => 'BOV Boliviano Mvdol',
                'sort_order' => 14,
                'symbol' => '$b'
            ],
            [
                'currency_abbreviation' => 'BRL',
                'currency_name' => 'Brazilian Real',
                'sort_order' => 15,
                'symbol' => 'R$'
            ],
            [
                'currency_abbreviation' => 'BSD',
                'currency_name' => 'Bahamian Dollar',
                'sort_order' => 16,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'BWP',
                'currency_name' => 'Pula',
                'sort_order' => 17,
                'symbol' => 'P'
            ],
            [
                'currency_abbreviation' => 'BYR',
                'currency_name' => 'Belarussian Ruble',
                'sort_order' => 18,
                'symbol' => '₽'
            ],
            [
                'currency_abbreviation' => 'BZD',
                'currency_name' => 'Belize Dollar',
                'sort_order' => 19,
                'symbol' => 'BZ$'
            ],
            [
                'currency_abbreviation' => 'CAD',
                'currency_name' => 'Canadian Dollar',
                'sort_order' => 20,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'CHF',
                'currency_name' => 'Swiss Franc',
                'sort_order' => 21,
                'symbol' => 'CHF'
            ],
            [
                'currency_abbreviation' => 'CLP',
                'currency_name' => 'CLF Chilean Peso Unidades de fomento',
                'sort_order' => 22,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'CNY',
                'currency_name' => 'Yuan Renminbi',
                'sort_order' => 23,
                'symbol' => '¥'
            ],
            [
                'currency_abbreviation' => 'COP',
                'currency_name' => 'COU Colombian Peso Unidad de Valor Real',
                'sort_order' => 24,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'CRC',
                'currency_name' => 'Costa Rican Colon',
                'sort_order' => 25,
                'symbol' => '₡'
            ],
            [
                'currency_abbreviation' => 'CUP',
                'currency_name' => 'CUC Cuban Peso Peso Convertible',
                'sort_order' => 26,
                'symbol' => '₱'
            ],
            [
                'currency_abbreviation' => 'CZK',
                'currency_name' => 'Czech Koruna',
                'sort_order' => 27,
                'symbol' => 'Kč'
            ],
            [
                'currency_abbreviation' => 'DKK',
                'currency_name' => 'Danish Krone',
                'sort_order' => 28,
                'symbol' => 'kr'
            ],
            [
                'currency_abbreviation' => 'DOP',
                'currency_name' => 'Dominican Peso',
                'sort_order' => 29,
                'symbol' => 'RD$'
            ],
            [
                'currency_abbreviation' => 'EGP',
                'currency_name' => 'Egyptian Pound',
                'sort_order' => 30,
                'symbol' => '£'
            ],
            [
                'currency_abbreviation' => 'EUR',
                'currency_name' => 'Euro',
                'sort_order' => 31,
                'symbol' => '€'
            ],
            [
                'currency_abbreviation' => 'FJD',
                'currency_name' => 'Fiji Dollar',
                'sort_order' => 32,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'FKP',
                'currency_name' => 'Falkland Islands Pound',
                'sort_order' => 33,
                'symbol' => '£'
            ],
            [
                'currency_abbreviation' => 'GBP',
                'currency_name' => 'Pound Sterling',
                'sort_order' => 34,
                'symbol' => '£'
            ],
            [
                'currency_abbreviation' => 'GIP',
                'currency_name' => 'Gibraltar Pound',
                'sort_order' => 35,
                'symbol' => '£'
            ],
            [
                'currency_abbreviation' => 'GTQ',
                'currency_name' => 'Quetzal',
                'sort_order' => 36,
                'symbol' => 'Q'
            ],
            [
                'currency_abbreviation' => 'GYD',
                'currency_name' => 'Guyana Dollar',
                'sort_order' => 37,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'HKD',
                'currency_name' => 'Hong Kong Dollar',
                'sort_order' => 38,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'HNL',
                'currency_name' => 'Lempira',
                'sort_order' => 39,
                'symbol' => 'L'
            ],
            [
                'currency_abbreviation' => 'HRK',
                'currency_name' => 'Croatian Kuna',
                'sort_order' => 40,
                'symbol' => 'kn'
            ],
            [
                'currency_abbreviation' => 'HUF',
                'currency_name' => 'Forint',
                'sort_order' => 41,
                'symbol' => 'Ft'
            ],
            [
                'currency_abbreviation' => 'IDR',
                'currency_name' => 'Rupiah',
                'sort_order' => 42,
                'symbol' => 'Rp'
            ],
            [
                'currency_abbreviation' => 'ILS',
                'currency_name' => 'New Israeli Sheqel',
                'sort_order' => 43,
                'symbol' => '₪'
            ],
            [
                'currency_abbreviation' => 'IRR',
                'currency_name' => 'Iranian Rial',
                'sort_order' => 44,
                'symbol' => '﷼'
            ],
            [
                'currency_abbreviation' => 'ISK',
                'currency_name' => 'Iceland Krona',
                'sort_order' => 45,
                'symbol' => 'kr'
            ],
            [
                'currency_abbreviation' => 'JMD',
                'currency_name' => 'Jamaican Dollar',
                'sort_order' => 46,
                'symbol' => 'J$'
            ],
            [
                'currency_abbreviation' => 'JPY',
                'currency_name' => 'Yen',
                'sort_order' => 47,
                'symbol' => '¥'
            ],
            [
                'currency_abbreviation' => 'KGS',
                'currency_name' => 'Som',
                'sort_order' => 48,
                'symbol' => 'лв'
            ],
            [
                'currency_abbreviation' => 'KHR',
                'currency_name' => 'Riel',
                'sort_order' => 49,
                'symbol' => '៛'
            ],
            [
                'currency_abbreviation' => 'KPW',
                'currency_name' => 'North Korean Won',
                'sort_order' => 50,
                'symbol' => '₩'
            ],
            [
                'currency_abbreviation' => 'KRW',
                'currency_name' => 'Won',
                'sort_order' => 51,
                'symbol' => '₩'
            ],
            [
                'currency_abbreviation' => 'KYD',
                'currency_name' => 'Cayman Islands Dollar',
                'sort_order' => 52,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'KZT',
                'currency_name' => 'Tenge',
                'sort_order' => 53,
                'symbol' => 'лв'
            ],
            [
                'currency_abbreviation' => 'LAK',
                'currency_name' => 'Kip',
                'sort_order' => 54,
                'symbol' => '₭'
            ],
            [
                'currency_abbreviation' => 'LBP',
                'currency_name' => 'Lebanese Pound',
                'sort_order' => 55,
                'symbol' => '£'
            ],
            [
                'currency_abbreviation' => 'LKR',
                'currency_name' => 'Sri Lanka Rupee',
                'sort_order' => 56,
                'symbol' => '₨'
            ],
            [
                'currency_abbreviation' => 'LRD',
                'currency_name' => 'Liberian Dollar',
                'sort_order' => 57,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'LTL',
                'currency_name' => 'Lithuanian Litas',
                'sort_order' => 58,
                'symbol' => 'Lt'
            ],
            [
                'currency_abbreviation' => 'LVL',
                'currency_name' => 'Latvian Lats',
                'sort_order' => 59,
                'symbol' => 'Ls'
            ],
            [
                'currency_abbreviation' => 'MKD',
                'currency_name' => 'Denar',
                'sort_order' => 60,
                'symbol' => 'ден'
            ],
            [
                'currency_abbreviation' => 'MNT',
                'currency_name' => 'Tugrik',
                'sort_order' => 61,
                'symbol' => '₮'
            ],
            [
                'currency_abbreviation' => 'MUR',
                'currency_name' => 'Mauritius Rupee',
                'sort_order' => 62,
                'symbol' => '₨'
            ],
            [
                'currency_abbreviation' => 'MXN',
                'currency_name' => 'MXV Mexican Peso Mexican Unidad de Inversion (UDI]',
                'sort_order' => 63,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'MYR',
                'currency_name' => 'Malaysian Ringgit',
                'sort_order' => 64,
                'symbol' => 'RM'
            ],
            [
                'currency_abbreviation' => 'MZN',
                'currency_name' => 'Metical',
                'sort_order' => 65,
                'symbol' => 'MT'
            ],
            [
                'currency_abbreviation' => 'NGN',
                'currency_name' => 'Naira',
                'sort_order' => 66,
                'symbol' => '₦'
            ],
            [
                'currency_abbreviation' => 'NIO',
                'currency_name' => 'Cordoba Oro',
                'sort_order' => 67,
                'symbol' => 'C$'
            ],
            [
                'currency_abbreviation' => 'NOK',
                'currency_name' => 'Norwegian Krone',
                'sort_order' => 68,
                'symbol' => 'kr'
            ],
            [
                'currency_abbreviation' => 'NPR',
                'currency_name' => 'Nepalese Rupee',
                'sort_order' => 69,
                'symbol' => '₨'
            ],
            [
                'currency_abbreviation' => 'NZD',
                'currency_name' => 'New Zealand Dollar',
                'sort_order' => 70,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'OMR',
                'currency_name' => 'Rial Omani',
                'sort_order' => 71,
                'symbol' => '﷼'
            ],
            [
                'currency_abbreviation' => 'PAB',
                'currency_name' => 'USD Balboa US Dollar',
                'sort_order' => 72,
                'symbol' => 'B/.'
            ],
            [
                'currency_abbreviation' => 'PEN',
                'currency_name' => 'Nuevo Sol',
                'sort_order' => 73,
                'symbol' => 'S/.'
            ],
            [
                'currency_abbreviation' => 'PHP',
                'currency_name' => 'Philippine Peso',
                'sort_order' => 74,
                'symbol' => 'Php'
            ],
            [
                'currency_abbreviation' => 'PKR',
                'currency_name' => 'Pakistan Rupee',
                'sort_order' => 75,
                'symbol' => '₨'
            ],
            [
                'currency_abbreviation' => 'PLN',
                'currency_name' => 'Zloty',
                'sort_order' => 76,
                'symbol' => 'zł'
            ],
            [
                'currency_abbreviation' => 'PYG',
                'currency_name' => 'Guarani',
                'sort_order' => 77,
                'symbol' => 'Gs'
            ],
            [
                'currency_abbreviation' => 'QAR',
                'currency_name' => 'Qatari Rial',
                'sort_order' => 78,
                'symbol' => '﷼'
            ],
            [
                'currency_abbreviation' => 'RON',
                'currency_name' => 'New Leu',
                'sort_order' => 79,
                'symbol' => 'lei'
            ],
            [
                'currency_abbreviation' => 'RSD',
                'currency_name' => 'Serbian Dinar',
                'sort_order' => 80,
                'symbol' => 'Дин.'
            ],
            [
                'currency_abbreviation' => 'RUB',
                'currency_name' => 'Russian Ruble',
                'sort_order' => 81,
                'symbol' => 'руб'
            ],
            [
                'currency_abbreviation' => 'SAR',
                'currency_name' => 'Saudi Riyal',
                'sort_order' => 82,
                'symbol' => '﷼'
            ],
            [
                'currency_abbreviation' => 'SBD',
                'currency_name' => 'Solomon Islands Dollar',
                'sort_order' => 83,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'SCR',
                'currency_name' => 'Seychelles Rupee',
                'sort_order' => 84,
                'symbol' => '₨'
            ],
            [
                'currency_abbreviation' => 'SEK',
                'currency_name' => 'Swedish Krona',
                'sort_order' => 85,
                'symbol' => 'kr'
            ],
            [
                'currency_abbreviation' => 'SGD',
                'currency_name' => 'Singapore Dollar',
                'sort_order' => 86,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'SHP',
                'currency_name' => 'Saint Helena Pound',
                'sort_order' => 87,
                'symbol' => '£'
            ],
            [
                'currency_abbreviation' => 'SOS',
                'currency_name' => 'Somali Shilling',
                'sort_order' => 88,
                'symbol' => 'S'
            ],
            [
                'currency_abbreviation' => 'SRD',
                'currency_name' => 'Surinam Dollar',
                'sort_order' => 89,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'SVC',
                'currency_name' => 'USD El Salvador Colon US Dollar',
                'sort_order' => 90,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'SYP',
                'currency_name' => 'Syrian Pound',
                'sort_order' => 91,
                'symbol' => '£'
            ],
            [
                'currency_abbreviation' => 'THB',
                'currency_name' => 'Baht',
                'sort_order' => 92,
                'symbol' => '฿'
            ],
            [
                'currency_abbreviation' => 'TRY',
                'currency_name' => 'Turkish Lira',
                'sort_order' => 93,
                'symbol' => 'TL'
            ],
            [
                'currency_abbreviation' => 'TTD',
                'currency_name' => 'Trinidad and Tobago Dollar',
                'sort_order' => 94,
                'symbol' => 'TT$'
            ],
            [
                'currency_abbreviation' => 'TWD',
                'currency_name' => 'New Taiwan Dollar',
                'sort_order' => 95,
                'symbol' => 'NT$'
            ],
            [
                'currency_abbreviation' => 'UAH',
                'currency_name' => 'Hryvnia',
                'sort_order' => 96,
                'symbol' => '₴'
            ],
            [
                'currency_abbreviation' => 'USD',
                'currency_name' => 'US Dollar',
                'sort_order' => 97,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'UYU',
                'currency_name' => 'UYI Uruguay Peso en Unidades Indexadas',
                'sort_order' => 98,
                'symbol' => '$U'
            ],
            [
                'currency_abbreviation' => 'UZS',
                'currency_name' => 'Uzbekistan Sum',
                'sort_order' => 99,
                'symbol' => 'лв'
            ],
            [
                'currency_abbreviation' => 'VEF',
                'currency_name' => 'Bolivar Fuerte',
                'sort_order' => 100,
                'symbol' => 'Bs'
            ],
            [
                'currency_abbreviation' => 'VND',
                'currency_name' => 'Dong',
                'sort_order' => 101,
                'symbol' => '₫'
            ],
            [
                'currency_abbreviation' => 'XCD',
                'currency_name' => 'East Caribbean Dollar',
                'sort_order' => 102,
                'symbol' => '$'
            ],
            [
                'currency_abbreviation' => 'YER',
                'currency_name' => 'Yemeni Rial',
                'sort_order' => 103,
                'symbol' => '﷼'
            ],
            [
                'currency_abbreviation' => 'ZAR',
                'currency_name' => 'Rand',
                'sort_order' => 104,
                'symbol' => 'R'
            ]
        ];

        foreach ($currency as $currency) {
        $existingCurrency = DB::table('currencies')
            ->where('currency_name', $currency['currency_name'])
            ->first();

        if (!$existingCurrency) {
            DB::table('currencies')->insert($currency);
        }
    }
}
}
