<?php

namespace Database\Seeders;

use App\Models\DateFormat;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DateFormatTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $paymentTerms = [
            [
                'format'            => 'Y-m-d',
                'format_details'    => 'YYYY-MM-DD',
                'is_default'        => 0,
            ],
            [
                'format'            => 'm/d/Y',
                'format_details'     => 'MM/DD/YYYY',
                'is_default'        => 0,
            ],
            [
                'format'            => 'd-m-Y',
                'format_details'    => 'DD-MM-YYYY',
                'is_default'        => 1,
            ],
            [
                'format'            =>'M d, Y',
                'format_details'    => 'Month Day, Year',
                'is_default'        => 0,
            ],
            [
                'format'            => 'j F Y',
                'format_details'    => 'Day Month Year (no leading zeros)',
                'is_default'        => 0,
            ],
            [
                'format'            => 'l, M d, Y',
                'format_details'    => 'Day, Month Day, Year',
                'is_default'        => 0,
            ],
            [
                'format'            => 'd.m.Y',
                'format_details'    => 'DD.MM.YYYY',
                'is_default'        => 0,
            ],
            [
                'format'            =>  'Y-M-d',
                'format_details'    => 'YYYY-Mon-DD',
                'is_default'        => 0,
            ],
            [
                'format'            => 'd/m/Y',
                'format_details'    => 'DD/MM/YYYY',
                'is_default'        => 0,
            ],
            [
                'format'            => 'F j, Y',
                'format_details'    =>'Month Day, Year (with leading zero)',
                'is_default'        => 0,
            ],
            [
                'format'            => 'd M Y',
                'format_details'    => 'Day Month Year',
                'is_default'        => 0,
            ]
        ];

        foreach ($paymentTerms as $data) {
            DateFormat::firstOrCreate(
                ['format' => $data['format']],
                $data
            );
        }
    }
}
