<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\DeliveryType;
class DeliveryTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $delivery_types = [
            [
                'name' => 'Godown Delivery',
                'code' => 'GODOWN_DELIVERY',
                'priority' => 1,
                'status' => 1,  
            ],
           [
                'name' => 'Door Delivery',
                'code' => 'DOOR_DELIVERY',
                'priority' => 2,
                'status' => 1,  
            ],
        ];

        foreach ($delivery_types as $data) {
            DeliveryType::firstOrCreate(
            [
                'name' => $data['name'],
                
            ],
                $data
            );
        } 
    }
}
