<?php

namespace Database\Seeders;

use App\Models\Designation;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DesignationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $designation = [
            [
                'name'       => 'Trainee',
                'code'       => 'TRAINEE',
                'priority'   => '1',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Junior',
                'code'       => 'JUNIOR',
                'priority'   => '2',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Senior',
                'code'       => 'SENIOR',
                'priority'   => '3',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Team Lead',
                'code'       => 'TEAM_LEAD',
                'priority'   => '4',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Project Manager',
                'code'       => 'PROJECT_MANAGER',
                'priority'   => '5',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Associate Professor',
                'code'       => 'ASSOCIATE_PROFESSOR',
                'priority'   => '6',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Assistant Professor',
                'code'       => 'ASSISTANT_PROFESSOR',
                'priority'   => '7',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Contractual Assistant Professor',
                'code'       => 'CONTRACTUAL_ASSISTANT_PROFESSOR',
                'priority'   => '8',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Computer Faculty',
                'code'       => 'COMPUTER_FACULTY',
                'priority'   => '9',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Coordinators',
                'code'       => 'COORDINATORS',
                'priority'   => '10',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Lecturers',
                'code'       => 'LECTURERS',
                'priority'   => '11',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Administrative',
                'code'       => 'ADMINISTRATIVE',
                'priority'   => '12',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Librarian',
                'code'       => 'LIBRARIAN',
                'priority'   => '13',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Chief Executive Officer',
                'code'       => 'CHIEF_EXECUTIVE_OFFICER',
                'priority'   => '14',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Chief Operating Officer',
                'code'       => 'CHIEF_OPERATING_OFFICER',
                'priority'   => '15',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Chief Financial Officer',
                'code'       => 'CHIEF_FINANCIAL_OFFICER',
                'priority'   => '16',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Chief Marketing Officer',
                'code'       => 'CHIEF_MARKETING_OFFICER',
                'priority'   => '17',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Chief Technology Officer',
                'code'       => 'CHIEF_TECHNOLOGY_OFFICER',
                'priority'   => '18',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Director',
                'code'       => 'DIRECTOR',
                'priority'   => '19',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Vice president',
                'code'       => 'VICE_PRESIDENT',
                'priority'   => '20',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Operations management',
                'code'       => 'OPERATIONS_MANAGEMENT',
                'priority'   => '21',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Chairman',
                'code'       => 'CHAIRMAN',
                'priority'   => '22',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'General counsel',
                'code'       => 'GENERAL_COUNSEL',
                'priority'   => '23',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Chief compliance officer',
                'code'       => 'CHIEF_COMPLIANCE_OFFICER',
                'priority'   => '24',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Secretary',
                'code'       => 'SECRETARY',
                'priority'   => '25',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'name'       => 'Executive officer',
                'code'       => 'EXECUTIVE_OFFICER',
                'priority'   => '26',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];

        foreach ($designation as $data) {
            Designation::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
