<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\DischargeType;

class DischargeTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $dischargeTypes = [
            [
				'name'       => 'Normal Discharge (NORMAL)',
				'code'       => 'NORMAL',
				'priority'   => '1',
				'is_default' => 1,
				'created_at' => date('Y-m-d H:i:s'),
				'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
				'name'       => 'Referral Discharge (REFERRAL)',
				'code'       => 'REFERRAL',
				'priority'   => '2',
				'is_default' => 0,
				'created_at' => date('Y-m-d H:i:s'),
				'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
				'name'       => 'Death Discharge (DEATH)',
				'code'       => 'DEATH',
				'priority'   => '3',
				'is_default' => 0,
				'created_at' => date('Y-m-d H:i:s'),
				'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];

        // DischargeType::insert($dischargeTypes);
        foreach ($dischargeTypes as $data) {
            DischargeType::firstOrCreate(
                ['code' => $data['code']],
                $data
            );
        }
    }
}
