<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DistrictsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (\App::environment('local')) {
            \DB::table('districts')->truncate();
        }

        \DB::statement("
                INSERT INTO `districts` (`id`, `district_name`, `district_short_name`, `district_numeric_code`, `state_id`, `status`) VALUES
                (1, 'Nicobars', 'NIC', 603, 1, 1),
                (2, 'North And Middle Andaman', 'NMA', 632, 1, 1),
                (3, 'South Andamans', 'SAS', 602, 1, 1),
                (4, 'Alluri Sitharama Raju', 'LLR', 745, 2, 1),
                (5, 'Anakapalli', 'NKP', 744, 2, 1),
                (6, 'Ananthapuramu', 'ANT', 502, 2, 1),
                (7, 'Annamayya', 'NNM', 753, 2, 1),
                (8, 'Bapatla', 'BPT', 750, 2, 1),
                (9, 'Chittoor', 'CHI', 503, 2, 1),
                (10, 'Dr. B.R. Ambedkar Konaseema', 'KNS', 747, 2, 1),
                (11, 'East Godavari', 'EGI', 505, 2, 1),
                (12, 'Eluru', 'LR', 748, 2, 1),
                (13, 'Guntur', 'GNT', 506, 2, 1),
                (14, 'Kakinada', 'KKN', 746, 2, 1),
                (15, 'Krishna', 'KRS', 510, 2, 1),
                (16, 'Kurnool', 'KUR', 511, 2, 1),
                (17, 'Nandyal', 'NND', 755, 2, 1),
                (18, 'Ntr', 'TNR', 749, 2, 1),
                (19, 'Palnadu', 'PLN', 751, 2, 1),
                (20, 'Parvathipuram Manyam', 'PRV', 743, 2, 1),
                (21, 'Prakasam', 'PRA', 517, 2, 1),
                (22, 'Srikakulam', 'SRK', 519, 2, 1),
                (23, 'Sri Potti Sriramulu Nellore', 'NEL', 515, 2, 1),
                (24, 'Sri Sathya Sai', 'SSS', 754, 2, 1),
                (25, 'Tirupati', 'TPT', 752, 2, 1),
                (26, 'Visakhapatnam', 'VSK', 520, 2, 1),
                (27, 'Vizianagaram', 'VNG', 521, 2, 1),
                (28, 'West Godavari', 'WGI', 523, 2, 1),
                (29, 'Y.S.R.', 'CUD', 504, 2, 1),
                (30, 'Anjaw', 'ANJ', 628, 3, 1),
                (31, 'Changlang', 'CHG', 229, 3, 1),
                (32, 'Dibang Valley', 'DBN', 230, 3, 1),
                (33, 'East Kameng', 'EKG', 231, 3, 1),
                (34, 'East Siang', 'ESG', 232, 3, 1),
                (35, 'Kamle', 'KML', 718, 3, 1),
                (36, 'Kra Daadi', 'KRD', 677, 3, 1),
                (37, 'Kurung Kumey', 'KKY', 233, 3, 1),
                (38, 'Leparada', 'LPR', 724, 3, 1),
                (39, 'Lohit', 'LHT', 234, 3, 1),
                (40, 'Longding', 'LDG', 666, 3, 1),
                (41, 'Lower Dibang Valley', 'LDV', 235, 3, 1),
                (42, 'Lower Siang', 'LWR', 719, 3, 1),
                (43, 'Lower Subansiri', 'LSI', 236, 3, 1),
                (44, 'Namsai', 'NMS', 678, 3, 1),
                (45, 'Pakke Kessang', 'PKK', 723, 3, 1),
                (46, 'Papum Pare', 'PPM', 237, 3, 1),
                (47, 'Shi Yomi', 'SHY', 725, 3, 1),
                (48, 'Siang', 'SAN', 679, 3, 1),
                (49, 'Tawang', 'TWN', 238, 3, 1),
                (50, 'Tirap', 'TRP', 239, 3, 1),
                (51, 'Upper Siang', 'USG', 240, 3, 1),
                (52, 'Upper Subansiri', 'USI', 241, 3, 1),
                (53, 'West Kameng', 'WKG', 242, 3, 1),
                (54, 'West Siang', 'WSG', 243, 3, 1),
                (55, 'Bajali', 'BJL', 739, 4, 1),
                (56, 'Baksa', 'BAK', 616, 4, 1),
                (57, 'Barpeta', 'BAR', 280, 4, 1),
                (58, 'Biswanath', 'BSW', 705, 4, 1),
                (59, 'Bongaigaon', 'BNG', 281, 4, 1),
                (60, 'Cachar', 'CCH', 282, 4, 1),
                (61, 'Charaideo', 'CID', 708, 4, 1),
                (62, 'Chirang', 'CRG', 612, 4, 1),
                (63, 'Darrang', 'DRR', 283, 4, 1),
                (64, 'Dhemaji', 'DHM', 284, 4, 1),
                (65, 'Dhubri', 'DHB', 285, 4, 1),
                (66, 'Dibrugarh', 'DBR', 286, 4, 1),
                (67, 'Dima Hasao', 'DHO', 299, 4, 1),
                (68, 'Goalpara', 'GLP', 287, 4, 1),
                (69, 'Golaghat', 'GLG', 288, 4, 1),
                (70, 'Hailakandi', 'HLK', 289, 4, 1),
                (71, 'Hojai', 'HJ', 709, 4, 1),
                (72, 'Jorhat', 'JRH', 290, 4, 1),
                (73, 'Kamrup', 'KMP', 291, 4, 1),
                (74, 'Kamrup Metro', 'KMT', 618, 4, 1),
                (75, 'Karbi Anglong', 'KAG', 292, 4, 1),
                (76, 'Karimganj', 'KGJ', 293, 4, 1),
                (77, 'Kokrajhar', 'KKR', 294, 4, 1),
                (78, 'Lakhimpur', 'LKP', 295, 4, 1),
                (79, 'Majuli', 'MJL', 706, 4, 1),
                (80, 'Marigaon', 'MGN', 296, 4, 1),
                (81, 'Nagaon', 'NGN', 297, 4, 1),
                (82, 'Nalbari', 'NLB', 298, 4, 1),
                (83, 'Sivasagar', 'SVS', 300, 4, 1),
                (84, 'Sonitpur', 'SON', 301, 4, 1),
                (85, 'South Salmara Mancachar', 'STH', 707, 4, 1),
                (86, 'Tamulpur', 'TML', 756, 4, 1),
                (87, 'Tinsukia', 'TIN', 302, 4, 1),
                (88, 'Udalguri', 'UDA', 617, 4, 1),
                (89, 'West Karbi Anglong', 'WST', 710, 4, 1),
                (90, 'Araria', 'ARA', 188, 5, 1),
                (91, 'Arwal', 'ARW', 611, 5, 1),
                (92, 'Aurangabad', 'AGB', 189, 5, 1),
                (93, 'Banka', 'BNK', 190, 5, 1),
                (94, 'Begusarai', 'BSR', 191, 5, 1),
                (95, 'Bhagalpur', 'BGO', 192, 5, 1),
                (96, 'Bhojpur', 'BJP', 193, 5, 1),
                (97, 'Buxar', 'BUX', 194, 5, 1),
                (98, 'Darbhanga', 'DBG', 195, 5, 1),
                (99, 'Gaya', 'GAY', 196, 5, 1),
                (100, 'Gopalganj', 'GPG', 197, 5, 1),
                (101, 'Jamui', 'JAM', 198, 5, 1),
                (102, 'Jehanabad', 'JHB', 199, 5, 1),
                (103, 'Kaimur (Bhabua)', 'KMR', 200, 5, 1),
                (104, 'Katihar', 'KTR', 201, 5, 1),
                (105, 'Khagaria', 'KGR', 202, 5, 1),
                (106, 'Kishanganj', 'KSG', 203, 5, 1),
                (107, 'Lakhisarai', 'LSR', 204, 5, 1),
                (108, 'Madhepura', 'MDP', 205, 5, 1),
                (109, 'Madhubani', 'MDB', 206, 5, 1),
                (110, 'Munger', 'MNG', 207, 5, 1),
                (111, 'Muzaffarpur', 'MUZ', 208, 5, 1),
                (112, 'Nalanda', 'NLD', 209, 5, 1),
                (113, 'Nawada', 'NAW', 210, 5, 1),
                (114, 'Pashchim Champaran', 'PSC', 211, 5, 1),
                (115, 'Patna', 'PTN', 212, 5, 1),
                (116, 'Purbi Champaran', 'PRC', 213, 5, 1),
                (117, 'Purnia', 'PRN', 214, 5, 1),
                (118, 'Rohtas', 'RTS', 215, 5, 1),
                (119, 'Saharsa', 'SHS', 216, 5, 1),
                (120, 'Samastipur', 'SMS', 217, 5, 1),
                (121, 'Saran', 'SAR', 218, 5, 1),
                (122, 'Sheikhpura', 'SHK', 219, 5, 1),
                (123, 'Sheohar', 'SHH', 220, 5, 1),
                (124, 'Sitamarhi', 'STM', 221, 5, 1),
                (125, 'Siwan', 'SWN', 222, 5, 1),
                (126, 'Supaul', 'SPL', 223, 5, 1),
                (127, 'Vaishali', 'VSH', 224, 5, 1),
                (128, 'Chandigarh', 'CHD', 44, 6, 1),
                (129, 'Balod', 'BLD', 646, 7, 1),
                (130, 'Balodabazar-Bhatapara', 'BLB', 644, 7, 1),
                (131, 'Balrampur-Ramanujganj', 'BLM', 649, 7, 1),
                (132, 'Bastar', 'BAS', 374, 7, 1),
                (133, 'Bemetara', 'BEM', 650, 7, 1),
                (134, 'Bijapur', 'BIJ', 636, 7, 1),
                (135, 'Bilaspur', 'BLP', 375, 7, 1),
                (136, 'Dakshin Bastar Dantewada', 'DNT', 376, 7, 1),
                (137, 'Dhamtari', 'DMT', 377, 7, 1),
                (138, 'Durg', 'DRG', 378, 7, 1),
                (139, 'Gariyaband', 'GRY', 645, 7, 1),
                (140, 'Gaurela-Pendra-Marwahi', 'GRL', 734, 7, 1),
                (141, 'Janjgir-Champa', 'JCH', 379, 7, 1),
                (142, 'Jashpur', 'JSH', 380, 7, 1),
                (143, 'Kabeerdham', 'KDM', 382, 7, 1),
                (144, 'Khairagarh-Chhuikhadan-Gandai', 'KCG', 759, 7, 1),
                (145, 'Kondagaon', 'KON', 643, 7, 1),
                (146, 'Korba', 'KRB', 383, 7, 1),
                (147, 'Korea', 'KOR', 384, 7, 1),
                (148, 'Mahasamund', 'MHS', 385, 7, 1),
                (149, 'Manendragarh-Chirmiri-Bharatpur(M C B)', 'MNN', 760, 7, 1),
                (150, 'Mohla-Manpur-Ambagarh Chouki', 'MHL', 761, 7, 1),
                (151, 'Mungeli', 'MUN', 647, 7, 1),
                (152, 'Narayanpur', 'NRY', 637, 7, 1),
                (153, 'Raigarh', 'RGR', 386, 7, 1),
                (154, 'Raipur', 'RPR', 387, 7, 1),
                (155, 'Rajnandgaon', 'RJN', 388, 7, 1),
                (156, 'Sakti', 'SKT', 762, 7, 1),
                (157, 'Sarangarh-Bilaigarh', 'SRB', 763, 7, 1),
                (158, 'Sukma', 'SKM', 642, 7, 1),
                (159, 'Surajpur', 'SRJ', 648, 7, 1),
                (160, 'Surguja', 'SRG', 389, 7, 1),
                (161, 'Uttar Bastar Kanker', 'KNK', 381, 7, 1),
                (162, 'Central', 'CNT', 77, 10, 1),
                (163, 'East', 'EST', 78, 10, 1),
                (164, 'New Delhi', 'NDL', 79, 10, 1),
                (165, 'North', 'NRD', 80, 10, 1),
                (166, 'North East', 'NED', 81, 10, 1),
                (167, 'North West', 'NWD', 82, 10, 1),
                (168, 'Shahdara', 'HHD', 671, 10, 1),
                (169, 'South', 'SDL', 83, 10, 1),
                (170, 'South East', 'STS', 670, 10, 1),
                (171, 'South West', 'SWD', 84, 10, 1),
                (172, 'West', 'WSD', 85, 10, 1),
                (173, 'North Goa', 'NGO', 551, 11, 1),
                (174, 'South Goa', 'SGO', 552, 11, 1),
                (175, 'Ahmedabad', 'AHM', 438, 12, 1),
                (176, 'Amreli', 'ARL', 439, 12, 1),
                (177, 'Anand', 'ANA', 440, 12, 1),
                (178, 'Arvalli', 'RVL', 672, 12, 1),
                (179, 'Banas Kantha', 'BKT', 441, 12, 1),
                (180, 'Bharuch', 'BRC', 442, 12, 1),
                (181, 'Bhavnagar', 'BHV', 443, 12, 1),
                (182, 'Botad', 'BTD', 676, 12, 1),
                (183, 'Chhotaudepur', 'CUP', 668, 12, 1),
                (184, 'Dahod', 'DHD', 445, 12, 1),
                (185, 'Dangs', 'DAN', 444, 12, 1),
                (186, 'Devbhumi Dwarka', 'DVB', 674, 12, 1),
                (187, 'Gandhinagar', 'GNR', 446, 12, 1),
                (188, 'Gir Somnath', 'GRS', 675, 12, 1),
                (189, 'Jamnagar', 'JMN', 447, 12, 1),
                (190, 'Junagadh', 'JNG', 448, 12, 1),
                (191, 'Kachchh', 'KCH', 449, 12, 1),
                (192, 'Kheda', 'KHE', 450, 12, 1),
                (193, 'Mahesana', 'MHN', 451, 12, 1),
                (194, 'Mahisagar', 'MSG', 669, 12, 1),
                (195, 'Morbi', 'MRI', 673, 12, 1),
                (196, 'Narmada', 'NRM', 452, 12, 1),
                (197, 'Navsari', 'NVS', 453, 12, 1),
                (198, 'Panch Mahals', 'PMS', 454, 12, 1),
                (199, 'Patan', 'PAT', 455, 12, 1),
                (200, 'Porbandar', 'PRB', 456, 12, 1),
                (201, 'Rajkot', 'RJK', 457, 12, 1),
                (202, 'Sabar Kantha', 'SKA', 458, 12, 1),
                (203, 'Surat', 'SRT', 459, 12, 1),
                (204, 'Surendranagar', 'SUR', 460, 12, 1),
                (205, 'Tapi', 'TAP', 641, 12, 1),
                (206, 'Vadodara', 'VDR', 461, 12, 1),
                (207, 'Valsad', 'VLS', 462, 12, 1),
                (208, 'Ambala', 'AMB', 58, 13, 1),
                (209, 'Bhiwani', 'BHW', 59, 13, 1),
                (210, 'Charki Dadri', 'HRK', 701, 13, 1),
                (211, 'Faridabad', 'FRB', 60, 13, 1),
                (212, 'Fatehabad', 'FTB', 61, 13, 1),
                (213, 'Gurugram', 'GRG', 62, 13, 1),
                (214, 'Hisar', 'HSR', 63, 13, 1),
                (215, 'Jhajjar', 'JHJ', 64, 13, 1),
                (216, 'Jind', 'JND', 65, 13, 1),
                (217, 'Kaithal', 'KTL', 66, 13, 1),
                (218, 'Karnal', 'KRL', 67, 13, 1),
                (219, 'Kurukshetra', 'KRK', 68, 13, 1),
                (220, 'Mahendragarh', 'MGH', 69, 13, 1),
                (221, 'Nuh', 'MWT', 604, 13, 1),
                (222, 'Palwal', 'PWL', 619, 13, 1),
                (223, 'Panchkula', 'PNK', 70, 13, 1),
                (224, 'Panipat', 'PNP', 71, 13, 1),
                (225, 'Rewari', 'RWR', 72, 13, 1),
                (226, 'Rohtak', 'RHT', 73, 13, 1),
                (227, 'Sirsa', 'SRS', 74, 13, 1),
                (228, 'Sonipat', 'SNP', 75, 13, 1),
                (229, 'Yamunanagar', 'YMN', 76, 13, 1),
                (230, 'Bilaspur', 'BLS', 15, 14, 1),
                (231, 'Chamba', 'CHM', 16, 14, 1),
                (232, 'Hamirpur', 'HMP', 17, 14, 1),
                (233, 'Kangra', 'KNG', 18, 14, 1),
                (234, 'Kinnaur', 'KIN', 19, 14, 1),
                (235, 'Kullu', 'KUL', 20, 14, 1),
                (236, 'Lahaul And Spiti', 'LAS', 21, 14, 1),
                (237, 'Mandi', 'MND', 22, 14, 1),
                (238, 'Shimla', 'SHM', 23, 14, 1),
                (239, 'Sirmaur', 'SRM', 24, 14, 1),
                (240, 'Solan', 'SLN', 25, 14, 1),
                (241, 'Una', 'UNA', 26, 14, 1),
                (242, 'Anantnag', 'ATG', 1, 15, 1),
                (243, 'Bandipora', 'BDP', 623, 15, 1),
                (244, 'Baramulla', 'BRM', 3, 15, 1),
                (245, 'Budgam', 'BDG', 2, 15, 1),
                (246, 'Doda', 'DOD', 4, 15, 1),
                (247, 'Ganderbal', 'GDR', 626, 15, 1),
                (248, 'Jammu', 'JMU', 5, 15, 1),
                (249, 'Kathua', 'KTH', 7, 15, 1),
                (250, 'Kishtwar', 'KHT', 620, 15, 1),
                (251, 'Kulgam', 'KLG', 622, 15, 1),
                (252, 'Kupwara', 'KPW', 8, 15, 1),
                (253, 'Poonch', 'PNC', 10, 15, 1),
                (254, 'Pulwama', 'PLW', 11, 15, 1),
                (255, 'Rajouri', 'RJR', 12, 15, 1),
                (256, 'Ramban', 'RMB', 621, 15, 1),
                (257, 'Reasi', 'REA', 627, 15, 1),
                (258, 'Samba', 'SAM', 624, 15, 1),
                (259, 'Shopian', 'SPN', 625, 15, 1),
                (260, 'Srinagar', 'SRN', 13, 15, 1),
                (261, 'Udhampur', 'UDM', 14, 15, 1),
                (262, 'Bokaro', 'BKR', 322, 16, 1),
                (263, 'Chatra', 'CHT', 323, 16, 1),
                (264, 'Deoghar', 'DGH', 324, 16, 1),
                (265, 'Dhanbad', 'DHN', 325, 16, 1),
                (266, 'Dumka', 'DMK', 326, 16, 1),
                (267, 'East Singhbum', 'ESM', 327, 16, 1),
                (268, 'Garhwa', 'GRH', 328, 16, 1),
                (269, 'Giridih', 'GIR', 329, 16, 1),
                (270, 'Godda', 'GDD', 330, 16, 1),
                (271, 'Gumla', 'GML', 331, 16, 1),
                (272, 'Hazaribagh', 'HZR', 332, 16, 1),
                (273, 'Jamtara', 'JMT', 333, 16, 1),
                (274, 'Khunti', 'KNT', 606, 16, 1),
                (275, 'Koderma', 'KDR', 334, 16, 1),
                (276, 'Latehar', 'LTH', 335, 16, 1),
                (277, 'Lohardaga', 'LHR', 336, 16, 1),
                (278, 'Pakur', 'PKR', 337, 16, 1),
                (279, 'Palamu', 'PLM', 338, 16, 1),
                (280, 'Ramgarh', 'RMG', 607, 16, 1),
                (281, 'Ranchi', 'RNC', 339, 16, 1),
                (282, 'Sahebganj', 'SGJ', 340, 16, 1),
                (283, 'Saraikela Kharsawan', 'SKH', 341, 16, 1),
                (284, 'Simdega', 'SMG', 342, 16, 1),
                (285, 'West Singhbhum', 'WSM', 343, 16, 1),
                (286, 'Bagalkote', 'BAG', 524, 17, 1),
                (287, 'Ballari', 'BLL', 528, 17, 1),
                (288, 'Belagavi', 'BLG', 527, 17, 1),
                (289, 'Bengaluru Rural', 'BRR', 526, 17, 1),
                (290, 'Bengaluru Urban', 'BUR', 525, 17, 1),
                (291, 'Bidar', 'BDR', 529, 17, 1),
                (292, 'Chamarajanagara', 'CHJ', 531, 17, 1),
                (293, 'Chikkaballapura', 'CHB', 630, 17, 1),
                (294, 'Chikkamagaluru', 'CKM', 532, 17, 1),
                (295, 'Chitradurga', 'CTR', 533, 17, 1),
                (296, 'Dakshina Kannada', 'DKD', 534, 17, 1),
                (297, 'Davangere', 'DAV', 535, 17, 1),
                (298, 'Dharwad', 'DRW', 536, 17, 1),
                (299, 'Gadag', 'GDG', 537, 17, 1),
                (300, 'Hassan', 'HAS', 539, 17, 1),
                (301, 'Haveri', 'HAV', 540, 17, 1),
                (302, 'Kalaburagi', 'KLB', 538, 17, 1),
                (303, 'Kodagu', 'KDG', 541, 17, 1),
                (304, 'Kolar', 'KLR', 542, 17, 1),
                (305, 'Koppal', 'KPL', 543, 17, 1),
                (306, 'Mandya', 'MDY', 544, 17, 1),
                (307, 'Mysuru', 'MYS', 545, 17, 1),
                (308, 'Raichur', 'RCH', 546, 17, 1),
                (309, 'Ramanagara', 'RAM', 631, 17, 1),
                (310, 'Shivamogga', 'SVM', 547, 17, 1),
                (311, 'Tumakuru', 'TMK', 548, 17, 1),
                (312, 'Udupi', 'UDU', 549, 17, 1),
                (313, 'Uttara Kannada', 'UKD', 550, 17, 1),
                (314, 'Vijayanagar', 'VJY', 738, 17, 1),
                (315, 'Vijayapura', 'VJP', 530, 17, 1),
                (316, 'Yadgir', 'YDG', 635, 17, 1),
                (317, 'Alappuzha', 'ALZ', 554, 19, 1),
                (318, 'Ernakulam', 'ERN', 555, 19, 1),
                (319, 'Idukki', 'IDK', 556, 19, 1),
                (320, 'Kannur', 'KNU', 557, 19, 1),
                (321, 'Kasaragod', 'KSR', 558, 19, 1),
                (322, 'Kollam', 'KLM', 559, 19, 1),
                (323, 'Kottayam', 'KTM', 560, 19, 1),
                (324, 'Kozhikode', 'KOZ', 561, 19, 1),
                (325, 'Malappuram', 'MLP', 562, 19, 1),
                (326, 'Palakkad', 'PLK', 563, 19, 1),
                (327, 'Pathanamthitta', 'PTT', 564, 19, 1),
                (328, 'Thiruvananthapuram', 'TVP', 565, 19, 1),
                (329, 'Thrissur', 'TSR', 566, 19, 1),
                (330, 'Wayanad', 'WAY', 567, 19, 1),
                (331, 'Kargil', 'KRG', 6, 0, 1),
                (332, 'Leh Ladakh', 'LLD', 9, 0, 1),
                (333, 'Lakshadweep District', 'LKS', 553, 20, 1),
                (334, 'Agar-Malwa', 'AGM', 667, 21, 1),
                (335, 'Alirajpur', 'ALI', 639, 21, 1),
                (336, 'Anuppur', 'ANP', 390, 21, 1),
                (337, 'Ashoknagar', 'ANR', 391, 21, 1),
                (338, 'Balaghat', 'BGT', 392, 21, 1),
                (339, 'Barwani', 'BRW', 393, 21, 1),
                (340, 'Betul', 'BTL', 394, 21, 1),
                (341, 'Bhind', 'BHN', 395, 21, 1),
                (342, 'Bhopal', 'BHP', 396, 21, 1),
                (343, 'Burhanpur', 'BRH', 397, 21, 1),
                (344, 'Chhatarpur', 'CRP', 398, 21, 1),
                (345, 'Chhindwara', 'CDW', 399, 21, 1),
                (346, 'Damoh', 'DMH', 400, 21, 1),
                (347, 'Datia', 'DAT', 401, 21, 1),
                (348, 'Dewas', 'DWS', 402, 21, 1),
                (349, 'Dhar', 'DHA', 403, 21, 1),
                (350, 'Dindori', 'DND', 404, 21, 1),
                (351, 'Guna', 'GUN', 406, 21, 1),
                (352, 'Gwalior', 'GWL', 407, 21, 1),
                (353, 'Harda', 'HDA', 408, 21, 1),
                (354, 'Indore', 'IND', 410, 21, 1),
                (355, 'Jabalpur', 'JBL', 411, 21, 1),
                (356, 'Jhabua', 'JHA', 412, 21, 1),
                (357, 'Katni', 'KTN', 413, 21, 1),
                (358, 'Khandwa (East Nimar)', 'ENR', 405, 21, 1),
                (359, 'Khargone (West Nimar)', 'KHA', 414, 21, 1),
                (360, 'Maihar', 'MHR', 784, 21, 1),
                (361, 'Mandla', 'MDL', 415, 21, 1),
                (362, 'Mandsaur', 'MAN', 416, 21, 1),
                (363, 'MAUGANJ', 'MGJ', 766, 21, 1),
                (364, 'Morena', 'MRN', 417, 21, 1),
                (365, 'Narmadapuram', 'HSH', 409, 21, 1),
                (366, 'Narsimhapur', 'NRS', 418, 21, 1),
                (367, 'Neemuch', 'NMC', 419, 21, 1),
                (368, 'Niwari', 'NWR', 722, 21, 1),
                (369, 'Pandhurna', 'PND', 785, 21, 1),
                (370, 'Panna', 'PNN', 420, 21, 1),
                (371, 'Raisen', 'RSN', 421, 21, 1),
                (372, 'Rajgarh', 'RJG', 422, 21, 1),
                (373, 'Ratlam', 'RTL', 423, 21, 1),
                (374, 'Rewa', 'REW', 424, 21, 1),
                (375, 'Sagar', 'SGR', 425, 21, 1),
                (376, 'Satna', 'STN', 426, 21, 1),
                (377, 'Sehore', 'SEH', 427, 21, 1),
                (378, 'Seoni', 'SEO', 428, 21, 1),
                (379, 'Shahdol', 'SHD', 429, 21, 1),
                (380, 'Shajapur', 'SJR', 430, 21, 1),
                (381, 'Sheopur', 'SHP', 431, 21, 1),
                (382, 'Shivpuri', 'SVP', 432, 21, 1),
                (383, 'Sidhi', 'SDH', 433, 21, 1),
                (384, 'Singrauli', 'SGL', 638, 21, 1),
                (385, 'Tikamgarh', 'TKM', 434, 21, 1),
                (386, 'Ujjain', 'UJJ', 435, 21, 1),
                (387, 'Umaria', 'UMA', 436, 21, 1),
                (388, 'Vidisha', 'VID', 437, 21, 1),
                (389, 'Ahmednagar', 'AHN', 466, 22, 1),
                (390, 'Akola', 'AKO', 467, 22, 1),
                (391, 'Amravati', 'AMV', 468, 22, 1),
                (392, 'Beed', 'BEE', 470, 22, 1),
                (393, 'Bhandara', 'BHA', 471, 22, 1),
                (394, 'Buldhana', 'BUL', 472, 22, 1),
                (395, 'Chandrapur', 'CPR', 473, 22, 1),
                (396, 'Nuapada', 'NPD', 368, 29, 1),
                (397, 'Chhatrapati Sambhajinagar', 'AUR', 469, 22, 1),
                (398, 'Dharashiv', 'OSM', 488, 22, 1),
                (399, 'Dhule', 'DHU', 474, 22, 1),
                (400, 'Gadchiroli', 'GDC', 475, 22, 1),
                (401, 'Gondia', 'GON', 476, 22, 1),
                (402, 'Hingoli', 'HIN', 477, 22, 1),
                (403, 'Jalgaon', 'JLG', 478, 22, 1),
                (404, 'Jalna', 'JAL', 479, 22, 1),
                (405, 'Kolhapur', 'KLP', 480, 22, 1),
                (406, 'Latur', 'LTR', 481, 22, 1),
                (407, 'Mumbai', 'MMB', 482, 22, 1),
                (408, 'Mumbai Suburban', 'MMS', 483, 22, 1),
                (409, 'Nagpur', 'NGP', 484, 22, 1),
                (410, 'Nanded', 'NAN', 485, 22, 1),
                (411, 'Nandurbar', 'NNR', 486, 22, 1),
                (412, 'Nashik', 'NSH', 487, 22, 1),
                (413, 'Palghar', 'PLG', 665, 22, 1),
                (414, 'Parbhani', 'PBN', 489, 22, 1),
                (415, 'Pune', 'PUN', 490, 22, 1),
                (416, 'Raigad', 'RGD', 491, 22, 1),
                (417, 'Ratnagiri', 'RTN', 492, 22, 1),
                (418, 'Sangli', 'SNG', 493, 22, 1),
                (419, 'Satara', 'SAT', 494, 22, 1),
                (420, 'Sindhudurg', 'SIN', 495, 22, 1),
                (421, 'Solapur', 'SOL', 496, 22, 1),
                (422, 'Thane', 'THN', 497, 22, 1),
                (423, 'Wardha', 'WRD', 498, 22, 1),
                (424, 'Washim', 'WSH', 499, 22, 1),
                (425, 'Yavatmal', 'YVT', 500, 22, 1),
                (426, 'Bishnupur', 'BSH', 252, 23, 1),
                (427, 'Chandel', 'CHA', 253, 23, 1),
                (428, 'Churachandpur', 'CHC', 254, 23, 1),
                (429, 'Imphal East', 'IME', 255, 23, 1),
                (430, 'Imphal West', 'IMW', 256, 23, 1),
                (431, 'Jiribam', 'JRB', 713, 23, 1),
                (432, 'Kakching', 'KKC', 711, 23, 1),
                (433, 'Kamjong', 'KMJ', 717, 23, 1),
                (434, 'Kangpokpi', 'KNP', 712, 23, 1),
                (435, 'Noney', 'NNY', 714, 23, 1),
                (436, 'Pherzawl', 'PHR', 715, 23, 1),
                (437, 'Senapati', 'SNT', 257, 23, 1),
                (438, 'Tamenglong', 'TMN', 258, 23, 1),
                (439, 'Tengnoupal', 'TNG', 716, 23, 1),
                (440, 'Thoubal', 'THB', 259, 23, 1),
                (441, 'Ukhrul', 'UKH', 260, 23, 1),
                (442, 'Eastern West Khasi Hills', 'EWK', 740, 24, 1),
                (443, 'East Garo Hills', 'EGH', 273, 24, 1),
                (444, 'East Jaintia Hills', 'EJH', 657, 24, 1),
                (445, 'East Khasi Hills', 'EKH', 274, 24, 1),
                (446, 'North Garo Hills', 'NGH', 656, 24, 1),
                (447, 'Ri Bhoi', 'RGH', 276, 24, 1),
                (448, 'South Garo Hills', 'SGH', 277, 24, 1),
                (449, 'South West Garo Hills', 'SWG', 663, 24, 1),
                (450, 'South West Khasi Hills', 'SWK', 658, 24, 1),
                (451, 'West Garo Hills', 'WGH', 278, 24, 1),
                (452, 'West Jaintia Hills', 'WJH', 275, 24, 1),
                (453, 'West Khasi Hills', 'WKA', 279, 24, 1),
                (454, 'Aizawl', 'AIZ', 261, 25, 1),
                (455, 'Champhai', 'CPH', 262, 25, 1),
                (456, 'Hnahthial', 'HNH', 726, 25, 1),
                (457, 'Khawzawl', 'KHW', 728, 25, 1),
                (458, 'Kolasib', 'KLS', 263, 25, 1),
                (459, 'Lawngtlai', 'LWN', 264, 25, 1),
                (460, 'Lunglei', 'LNG', 265, 25, 1),
                (461, 'Mamit', 'MMT', 266, 25, 1),
                (462, 'Saitual', 'STL', 727, 25, 1),
                (463, 'Serchhip', 'SER', 268, 25, 1),
                (464, 'Siaha', 'SAI', 267, 25, 1),
                (465, 'Chumoukedima', 'CKD', 758, 26, 1),
                (466, 'Dimapur', 'DMP', 244, 26, 1),
                (467, 'Kiphire', 'KIP', 614, 26, 1),
                (468, 'Kohima', 'KHM', 245, 26, 1),
                (469, 'Longleng', 'LLG', 615, 26, 1),
                (470, 'Mokokchung', 'MKK', 246, 26, 1),
                (471, 'Mon', 'MON', 247, 26, 1),
                (472, 'Niuland', 'NLN', 764, 26, 1),
                (473, 'Noklak', 'NKL', 736, 26, 1),
                (474, 'Peren', 'PER', 613, 26, 1),
                (475, 'Phek', 'PHK', 248, 26, 1),
                (476, 'Shamator', 'SMR', 765, 26, 1),
                (477, 'Tseminyu', 'TSM', 757, 26, 1),
                (478, 'Tuensang', 'TNS', 249, 26, 1),
                (479, 'Wokha', 'WKH', 250, 26, 1),
                (480, 'Zunheboto', 'ZNH', 251, 26, 1),
                (481, 'Anugul', 'ANU', 344, 29, 1),
                (482, 'Balangir', 'BLN', 345, 29, 1),
                (483, 'Baleshwar', 'BLW', 346, 29, 1),
                (484, 'Bargarh', 'BRG', 347, 29, 1),
                (485, 'Bhadrak', 'BDK', 348, 29, 1),
                (486, 'Boudh', 'BDH', 349, 29, 1),
                (487, 'Cuttack', 'CTT', 350, 29, 1),
                (488, 'Deogarh', 'DGR', 351, 29, 1),
                (489, 'Dhenkanal', 'DHK', 352, 29, 1),
                (490, 'Gajapati', 'GJP', 353, 29, 1),
                (491, 'Ganjam', 'GNJ', 354, 29, 1),
                (492, 'Jagatsinghapur', 'JGT', 355, 29, 1),
                (493, 'Jajapur', 'JJP', 356, 29, 1),
                (494, 'Jharsuguda', 'JHR', 357, 29, 1),
                (495, 'Kalahandi', 'KLH', 358, 29, 1),
                (496, 'Kandhamal', 'KNM', 359, 29, 1),
                (497, 'Kendrapara', 'KND', 360, 29, 1),
                (498, 'Kendujhar', 'KNH', 361, 29, 1),
                (499, 'Khordha', 'KHD', 362, 29, 1),
                (500, 'Koraput', 'KRP', 363, 29, 1),
                (501, 'Malkangiri', 'MLK', 364, 29, 1),
                (502, 'Mayurbhanj', 'MYR', 365, 29, 1),
                (503, 'Nabarangpur', 'NBR', 366, 29, 1),
                (504, 'Nayagarh', 'NYG', 367, 29, 1),
                (505, 'Puri', 'PUR', 369, 29, 1),
                (506, 'Rayagada', 'RYG', 370, 29, 1),
                (507, 'Sambalpur', 'SMB', 371, 29, 1),
                (508, 'Sonepur', 'SNE', 372, 29, 1),
                (509, 'Sundargarh', 'SDG', 373, 29, 1),
                (510, 'Karaikal', 'KKL', 598, 0, 1),
                (511, 'Mahe', 'MHE', 599, 0, 1),
                (512, 'Puducherry', 'PON', 600, 0, 1),
                (513, 'Yanam', 'YAN', 601, 0, 1),
                (514, 'Amritsar', 'AMT', 27, 32, 1),
                (515, 'Barnala', 'BNL', 605, 32, 1),
                (516, 'Bathinda', 'BTH', 28, 32, 1),
                (517, 'Faridkot', 'FRD', 29, 32, 1),
                (518, 'Fatehgarh Sahib', 'FTG', 30, 32, 1),
                (519, 'Fazilka', 'FAZ', 651, 32, 1),
                (520, 'Ferozepur', 'FRZ', 31, 32, 1),
                (521, 'Gurdaspur', 'GRD', 32, 32, 1),
                (522, 'Hoshiarpur', 'HSP', 33, 32, 1),
                (523, 'Jalandhar', 'JLN', 34, 32, 1),
                (524, 'Kapurthala', 'KPR', 35, 32, 1),
                (525, 'Ludhiana', 'LDH', 36, 32, 1),
                (526, 'Malerkotla', 'MLR', 737, 32, 1),
                (527, 'Mansa', 'MNS', 37, 32, 1),
                (528, 'Moga', 'MOG', 38, 32, 1),
                (529, 'Pathankot', 'PTK', 662, 32, 1),
                (530, 'Patiala', 'PTL', 41, 32, 1),
                (531, 'Rupnagar', 'RPN', 42, 32, 1),
                (532, 'Sangrur', 'SNR', 43, 32, 1),
                (533, 'S.A.S Nagar', 'SSR', 608, 32, 1),
                (534, 'Shahid Bhagat Singh Nagar', 'NWN', 40, 32, 1),
                (535, 'Sri Muktsar Sahib', 'SMT', 39, 32, 1),
                (536, 'Tarn Taran', 'TAR', 609, 32, 1),
                (537, 'Ajmer', 'AJM', 86, 33, 1),
                (538, 'Alwar', 'ALW', 87, 33, 1),
                (539, 'Anupgarh', 'NPG', 776, 33, 1),
                (540, 'Balotra', 'BLT', 775, 33, 1),
                (541, 'Banswara', 'BNS', 88, 33, 1),
                (542, 'Baran', 'BRN', 89, 33, 1),
                (543, 'Barmer', 'BMR', 90, 33, 1),
                (544, 'Beawar', 'BWR', 774, 33, 1),
                (545, 'Bharatpur', 'BTR', 91, 33, 1),
                (546, 'Bhilwara', 'BHL', 92, 33, 1),
                (547, 'Bikaner', 'BIK', 93, 33, 1),
                (548, 'Bundi', 'BND', 94, 33, 1),
                (549, 'Chittorgarh', 'CGH', 95, 33, 1),
                (550, 'Churu', 'CHR', 96, 33, 1),
                (551, 'Dausa', 'DAS', 97, 33, 1),
                (552, 'Deeg', 'DEE', 767, 33, 1),
                (553, 'Dholpur', 'DLP', 98, 33, 1),
                (554, 'Didwana-Kuchaman', 'DDW', 768, 33, 1),
                (555, 'Dudu', 'DDU', 769, 33, 1),
                (556, 'Dungarpur', 'DNG', 99, 33, 1),
                (557, 'Ganganagar', 'GNG', 100, 33, 1),
                (558, 'Gangapurcity', 'GCT', 771, 33, 1),
                (559, 'Hanumangarh', 'HGH', 101, 33, 1),
                (560, 'Jaipur', 'JPR', 102, 33, 1),
                (561, 'Jaipur (Gramin)', 'JPG', 783, 33, 1),
                (562, 'Jaisalmer', 'JSL', 103, 33, 1),
                (563, 'Jalore', 'JLR', 104, 33, 1),
                (564, 'Jhalawar', 'JHL', 105, 33, 1),
                (565, 'Jhunjhunu', 'JHN', 106, 33, 1),
                (566, 'Jodhpur', 'JDH', 107, 33, 1),
                (567, 'Jodhpur (Gramin)', 'JDG', 778, 33, 1),
                (568, 'Karauli', 'KAR', 108, 33, 1),
                (569, 'Kekri', 'KRI', 781, 33, 1),
                (570, 'Khairthal-Tijara', 'KTJ', 770, 33, 1),
                (571, 'Kota', 'KOT', 109, 33, 1),
                (572, 'Kotputli-Behror', 'KTP', 782, 33, 1),
                (573, 'Nagaur', 'NGR', 110, 33, 1),
                (574, 'Neem Ka Thana', 'NKT', 773, 33, 1),
                (575, 'Pali', 'PAL', 111, 33, 1),
                (576, 'Phalodi', 'PHL', 772, 33, 1),
                (577, 'Pratapgarh', 'PPG', 629, 33, 1),
                (578, 'Rajsamand', 'RJS', 112, 33, 1),
                (579, 'Salumbar', 'SLR', 777, 33, 1),
                (580, 'Sanchore', 'SNC', 779, 33, 1),
                (581, 'Sawai Madhopur', 'SMP', 113, 33, 1),
                (582, 'Shahpura', 'SPR', 780, 33, 1),
                (583, 'Sikar', 'SKR', 114, 33, 1),
                (584, 'Sirohi', 'SRH', 115, 33, 1),
                (585, 'Tonk', 'TNK', 116, 33, 1),
                (586, 'Udaipur', 'UDP', 117, 33, 1),
                (587, 'Gangtok', 'EDT', 225, 34, 1),
                (588, 'Gyalshing', 'WDT', 228, 34, 1),
                (589, 'Mangan', 'NDT', 226, 34, 1),
                (590, 'Namchi', 'SDT', 227, 34, 1),
                (591, 'Pakyong', 'PKY', 741, 34, 1),
                (592, 'Soreng', 'GNS', 742, 34, 1),
                (593, 'Ariyalur', 'ARI', 610, 35, 1),
                (594, 'Chengalpattu', 'CGL', 730, 35, 1),
                (595, 'Chennai', 'CHE', 568, 35, 1),
                (596, 'Coimbatore', 'CMT', 569, 35, 1),
                (597, 'Cuddalore', 'CDL', 570, 35, 1),
                (598, 'Dharmapuri', 'DRM', 571, 35, 1),
                (599, 'Dindigul', 'DIN', 572, 35, 1),
                (600, 'Erode', 'ERO', 573, 35, 1),
                (601, 'Kallakurichi', 'KLL', 729, 35, 1),
                (602, 'Kancheepuram', 'KCP', 574, 35, 1),
                (603, 'Kanniyakumari', 'KNY', 575, 35, 1),
                (604, 'Karur', 'KRR', 576, 35, 1),
                (605, 'Krishnagiri', 'KHN', 577, 35, 1),
                (606, 'Madurai', 'MDR', 578, 35, 1),
                (607, 'Mayiladuthurai', 'MYL', 735, 35, 1),
                (608, 'Nagapattinam', 'NPM', 579, 35, 1),
                (609, 'Namakkal', 'NMK', 580, 35, 1),
                (610, 'Perambalur', 'PRM', 581, 35, 1),
                (611, 'Pudukkottai', 'PDK', 582, 35, 1),
                (612, 'Ramanathapuram', 'RMN', 583, 35, 1),
                (613, 'Ranipet', 'RNP', 731, 35, 1),
                (614, 'Salem', 'SLM', 584, 35, 1),
                (615, 'Sivaganga', 'SGG', 585, 35, 1),
                (616, 'Tenkasi', 'TKS', 733, 35, 1),
                (617, 'Thanjavur', 'TJV', 586, 35, 1),
                (618, 'Theni', 'THE', 588, 35, 1),
                (619, 'The Nilgiris', 'NIL', 587, 35, 1),
                (620, 'Thiruvallur', 'TRV', 589, 35, 1),
                (621, 'Thiruvarur', 'TVV', 590, 35, 1),
                (622, 'Thoothukkudi', 'TUT', 594, 35, 1),
                (623, 'Tiruchirappalli', 'TRC', 591, 35, 1),
                (624, 'Tirunelveli', 'TRN', 592, 35, 1),
                (625, 'Tirupathur', 'TPR', 732, 35, 1),
                (626, 'Tiruppur', 'TRR', 634, 35, 1),
                (627, 'Tiruvannamalai', 'TVN', 593, 35, 1),
                (628, 'Vellore', 'VEL', 595, 35, 1),
                (629, 'Viluppuram', 'VIL', 596, 35, 1),
                (630, 'Virudhunagar', 'VIR', 597, 35, 1),
                (631, 'Adilabad', 'ADI', 501, 36, 1),
                (632, 'Bhadradri Kothagudem', 'BHD', 690, 36, 1),
                (633, 'Hanumakonda', 'WRN', 686, 36, 1),
                (634, 'Hyderabad', 'HYD', 507, 36, 1),
                (635, 'Jagitial', 'JGI', 681, 36, 1),
                (636, 'Jangoan', 'JNN', 689, 36, 1),
                (637, 'Jayashankar Bhupalapally', 'JYS', 687, 36, 1),
                (638, 'Jogulamba Gadwal', 'JGL', 695, 36, 1),
                (639, 'Kamareddy', 'KMD', 685, 36, 1),
                (640, 'Karimnagar', 'KRM', 508, 36, 1),
                (641, 'Khammam', 'KMM', 509, 36, 1),
                (642, 'Kumuram Bheem Asifabad', 'KMB', 699, 36, 1),
                (643, 'Mahabubabad', 'MHD', 688, 36, 1),
                (644, 'Mahabubnagar', 'MAH', 512, 36, 1),
                (645, 'Mancherial', 'MNC', 684, 36, 1),
                (646, 'Medak', 'MDK', 513, 36, 1),
                (647, 'Medchal Malkajgiri', 'MDC', 700, 36, 1),
                (648, 'Mulugu', 'MLG', 720, 36, 1),
                (649, 'Nagarkurnool', 'NGK', 694, 36, 1),
                (650, 'Nalgonda', 'NLG', 514, 36, 1),
                (651, 'Narayanpet', 'NRN', 721, 36, 1),
                (652, 'Nirmal', 'NRL', 680, 36, 1),
                (653, 'Nizamabad', 'NIZ', 516, 36, 1),
                (654, 'Peddapalli', 'PDD', 682, 36, 1),
                (655, 'Rajanna Sircilla', 'RJC', 683, 36, 1),
                (656, 'Ranga Reddy', 'RNG', 518, 36, 1),
                (657, 'Sangareddy', 'SND', 691, 36, 1),
                (658, 'Siddipet', 'SDD', 692, 36, 1),
                (659, 'Suryapet', 'SRY', 696, 36, 1),
                (660, 'Vikarabad', 'VKR', 698, 36, 1),
                (661, 'Wanaparthy', 'WNP', 693, 36, 1),
                (662, 'Warangal', 'WAR', 522, 36, 1),
                (663, 'Yadadri Bhuvanagiri', 'YDD', 697, 36, 1),
                (664, 'Dadra And Nagar Haveli', 'DNH', 465, 0, 1),
                (665, 'Daman', 'DMN', 463, 0, 1),
                (666, 'Diu', 'DIU', 464, 0, 1),
                (667, 'Dhalai', 'DHL', 269, 37, 1),
                (668, 'Gomati', 'GOM', 654, 37, 1),
                (669, 'Khowai', 'KHO', 652, 37, 1),
                (670, 'North Tripura', 'NTR', 270, 37, 1),
                (671, 'Sepahijala', 'SEP', 653, 37, 1),
                (672, 'South Tripura', 'STR', 271, 37, 1),
                (673, 'Unakoti', 'UNK', 655, 37, 1),
                (674, 'West Tripura', 'WTR', 272, 37, 1),
                (675, 'Almora', 'ALM', 45, 39, 1),
                (676, 'Bageshwar', 'BGS', 46, 39, 1),
                (677, 'Chamoli', 'CHL', 47, 39, 1),
                (678, 'Champawat', 'CHP', 48, 39, 1),
                (679, 'Dehradun', 'DHR', 49, 39, 1),
                (680, 'Haridwar', 'HRD', 50, 39, 1),
                (681, 'Nainital', 'NNT', 51, 39, 1),
                (682, 'Pauri Garhwal', 'PGR', 52, 39, 1),
                (683, 'Pithoragarh', 'PTH', 53, 39, 1),
                (684, 'Rudra Prayag', 'RPY', 54, 39, 1),
                (685, 'Tehri Garhwal', 'TGR', 55, 39, 1),
                (686, 'Udam Singh Nagar', 'USN', 56, 39, 1),
                (687, 'Uttar Kashi', 'UKS', 57, 39, 1),
                (688, 'Agra', 'AGR', 118, 38, 1),
                (689, 'Aligarh', 'ALG', 119, 38, 1),
                (690, 'Ambedkar Nagar', 'AMN', 121, 38, 1),
                (691, 'Amethi', 'AME', 640, 38, 1),
                (692, 'Amroha', 'AMR', 154, 38, 1),
                (693, 'Auraiya', 'ARY', 122, 38, 1),
                (694, 'Ayodhya', 'FZB', 140, 38, 1),
                (695, 'Azamgarh', 'AZM', 123, 38, 1),
                (696, 'Baghpat', 'BGP', 124, 38, 1),
                (697, 'Bahraich', 'BHR', 125, 38, 1),
                (698, 'Ballia', 'BAL', 126, 38, 1),
                (699, 'Balrampur', 'BRP', 127, 38, 1),
                (700, 'Banda', 'BAN', 128, 38, 1),
                (701, 'Bara Banki', 'BRB', 129, 38, 1),
                (702, 'Bareilly', 'BRL', 130, 38, 1),
                (703, 'Basti', 'BST', 131, 38, 1),
                (704, 'Bhadohi', 'SRD', 179, 38, 1),
                (705, 'Bijnor', 'BJN', 132, 38, 1),
                (706, 'Budaun', 'BDN', 133, 38, 1),
                (707, 'Bulandshahr', 'BLR', 134, 38, 1),
                (708, 'Chandauli', 'CHN', 135, 38, 1),
                (709, 'Chitrakoot', 'CHK', 136, 38, 1),
                (710, 'Deoria', 'DER', 137, 38, 1),
                (711, 'Etah', 'ETA', 138, 38, 1),
                (712, 'Etawah', 'ETW', 139, 38, 1),
                (713, 'Farrukhabad', 'FKB', 141, 38, 1),
                (714, 'Fatehpur', 'FTP', 142, 38, 1),
                (715, 'Firozabad', 'FIR', 143, 38, 1),
                (716, 'Gautam Buddha Nagar', 'GBN', 144, 38, 1),
                (717, 'Ghaziabad', 'GZB', 145, 38, 1),
                (718, 'Ghazipur', 'GZP', 146, 38, 1),
                (719, 'Gonda', 'GND', 147, 38, 1),
                (720, 'Gorakhpur', 'GKP', 148, 38, 1),
                (721, 'Hamirpur', 'HRP', 149, 38, 1),
                (722, 'Hapur', 'HAP', 661, 38, 1),
                (723, 'Hardoi', 'HAR', 150, 38, 1),
                (724, 'Hathras', 'HTR', 163, 38, 1),
                (725, 'Jalaun', 'JLU', 151, 38, 1),
                (726, 'Jaunpur', 'JNP', 152, 38, 1),
                (727, 'Jhansi', 'JHS', 153, 38, 1),
                (728, 'Kannauj', 'KNJ', 155, 38, 1),
                (729, 'Kanpur Dehat', 'KPD', 156, 38, 1),
                (730, 'Kanpur Nagar', 'KPN', 157, 38, 1),
                (731, 'Kasganj', 'KAS', 633, 38, 1),
                (732, 'Kaushambi', 'KSB', 158, 38, 1),
                (733, 'Kheri', 'KHR', 159, 38, 1),
                (734, 'Kushinagar', 'KSN', 160, 38, 1),
                (735, 'Lalitpur', 'LLP', 161, 38, 1),
                (736, 'Lucknow', 'LCK', 162, 38, 1),
                (737, 'Mahoba', 'MHB', 165, 38, 1),
                (738, 'Mahrajganj', 'MRG', 164, 38, 1),
                (739, 'Mainpuri', 'MPR', 166, 38, 1),
                (740, 'Mathura', 'MTH', 167, 38, 1),
                (741, 'Mau', 'MAU', 168, 38, 1),
                (742, 'Meerut', 'MRT', 169, 38, 1),
                (743, 'Mirzapur', 'MZP', 170, 38, 1),
                (744, 'Moradabad', 'MRB', 171, 38, 1),
                (745, 'Muzaffarnagar', 'MZN', 172, 38, 1),
                (746, 'Pilibhit', 'PLB', 173, 38, 1),
                (747, 'Pratapgarh', 'PRG', 174, 38, 1),
                (748, 'Prayagraj', 'ALB', 120, 38, 1),
                (749, 'Rae Bareli', 'RBL', 175, 38, 1),
                (750, 'Rampur', 'RMP', 176, 38, 1),
                (751, 'Saharanpur', 'SHR', 177, 38, 1),
                (752, 'Sambhal', 'SBL', 659, 38, 1),
                (753, 'Sant Kabir Nagar', 'SKN', 178, 38, 1),
                (754, 'Shahjahanpur', 'SJN', 180, 38, 1),
                (755, 'Shamli', 'SML', 660, 38, 1),
                (756, 'Shrawasti', 'SHV', 181, 38, 1),
                (757, 'Siddharthnagar', 'SDN', 182, 38, 1),
                (758, 'Sitapur', 'STP', 183, 38, 1),
                (759, 'Sonbhadra', 'SBD', 184, 38, 1),
                (760, 'Sultanpur', 'SLP', 185, 38, 1),
                (761, 'Unnao', 'UNO', 186, 38, 1),
                (762, 'Varanasi', 'VRN', 187, 38, 1),
                (763, 'Alipurduar', 'APD', 664, 41, 1),
                (764, 'Bankura', 'BNR', 305, 41, 1),
                (765, 'Birbhum', 'BIR', 307, 41, 1),
                (766, 'Cooch Behar', 'CBH', 308, 41, 1),
                (767, 'Dakshin Dinajpur', 'DPD', 310, 41, 1),
                (768, 'Darjeeling', 'DRJ', 309, 41, 1),
                (769, 'Hooghly', 'HOO', 312, 41, 1),
                (770, 'Howrah', 'HWR', 313, 41, 1),
                (771, 'Jalpaiguri', 'JLP', 314, 41, 1),
                (772, 'Jhargram', 'GRM', 703, 41, 1),
                (773, 'Kalimpong', 'MPN', 702, 41, 1),
                (774, 'Kolkata', 'KLK', 315, 41, 1),
                (775, 'Malda', 'MLD', 316, 41, 1),
                (776, 'Murshidabad', 'MRS', 319, 41, 1),
                (777, 'Nadia', 'NAD', 320, 41, 1),
                (778, 'North 24 Parganas', 'S24', 303, 41, 1),
                (779, 'Paschim Bardhaman', 'MBR', 704, 41, 1),
                (780, 'Paschim Medinipur', 'MPW', 318, 41, 1),
                (781, 'Purba Bardhaman', 'BRD', 306, 41, 1),
                (782, 'Purba Medinipur', 'MPE', 317, 41, 1),
                (783, 'Purulia', 'PRL', 321, 41, 1),
                (784, 'South 24 Parganas', 'N24', 304, 41, 1),
                (785, 'Uttar Dinajpur', 'DPU', 311, 41, 1);");
    }
}
